package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.reports.CDECentralCounterpartyRule;
import javax.inject.Inject;


@ImplementedBy(CentralCounterpartyRule.CentralCounterpartyRuleDefault.class)
public abstract class CentralCounterpartyRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDECentralCounterpartyRule cDECentralCounterpartyRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class CentralCounterpartyRuleDefault extends CentralCounterpartyRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			output = cDECentralCounterpartyRule.evaluate(input);
			
			return output;
		}
	}
}
