package drr.regulation.cftc.rewrite.reports;

import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.reports.CDEExchangeRateBasisRule;
import drr.standards.iosco.cde.reports.CDEExchangeRateRule;
import javax.inject.Inject;


@ImplementedBy(ExchangeRateBasisRule.ExchangeRateBasisRuleDefault.class)
public abstract class ExchangeRateBasisRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEExchangeRateBasisRule cDEExchangeRateBasisRule;
	@Inject protected CDEExchangeRateRule cDEExchangeRateRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class ExchangeRateBasisRuleDefault extends ExchangeRateBasisRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<PriceSchedule> thenArg = MapperS.of(cDEExchangeRateRule.evaluate(input));
			output = MapperS.of(cDEExchangeRateBasisRule.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
