package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.reports.CDEPackageTransactionPriceNotationEnumRule;
import drr.standards.iso.PriceNotationEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetPackageTransactionPriceNotationEnumRule.GetPackageTransactionPriceNotationEnumRuleDefault.class)
public abstract class GetPackageTransactionPriceNotationEnumRule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPackageTransactionPriceNotationEnumRule cDEPackageTransactionPriceNotationEnumRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class GetPackageTransactionPriceNotationEnumRuleDefault extends GetPackageTransactionPriceNotationEnumRule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			if (areEqual(MapperS.of(cDEPackageTransactionPriceNotationEnumRule.evaluate(input)), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
				output = PriceNotationEnum.DECIMAL;
			} else {
				output = cDEPackageTransactionPriceNotationEnumRule.evaluate(input);
			}
			
			return output;
		}
	}
}
