package drr.regulation.cftc.rewrite.reports;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.common.settlement.FixedPrice;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_InterestRate_Option_Swaption;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.CommodityBasisLegWithNoSpread;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.CommodityObservablePriceQuantity;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.FXLeg2;
import drr.regulation.common.functions.FXSwapLeg2;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsFXForward;
import drr.regulation.common.functions.IsFXOption;
import drr.regulation.common.functions.IsFXSwap;
import drr.regulation.common.functions.LastAvailableSpotPrice;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.standards.iosco.cde.functions.CDECommodityNotional;
import drr.standards.iosco.cde.reports.CDEFXNotionalRule;
import drr.standards.iosco.cde.reports.CDEInterestRateNotionalRule;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(NotionalAmountLeg2Rule.NotionalAmountLeg2RuleDefault.class)
public abstract class NotionalAmountLeg2Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected BeforeTradeForEvent beforeTradeForEvent;
	@Inject protected CDECommodityNotional cDECommodityNotional;
	@Inject protected CDEFXNotionalRule cDEFXNotionalRule;
	@Inject protected CDEInterestRateNotionalRule cDEInterestRateNotionalRule;
	@Inject protected CommodityBasisLegWithNoSpread commodityBasisLegWithNoSpread;
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected CommodityObservablePriceQuantity commodityObservablePriceQuantity;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FXLeg2 fXLeg2;
	@Inject protected FXSwapLeg2 fXSwapLeg2;
	@Inject protected FixedPriceLeg1 fixedPriceLeg1;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected IsFXForward isFXForward;
	@Inject protected IsFXOption isFXOption;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected LastAvailableSpotPrice lastAvailableSpotPrice;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
	@Inject protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_InterestRate_Option_Swaption qualify_InterestRate_Option_Swaption;
	@Inject protected TradeForEvent tradeForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class NotionalAmountLeg2RuleDefault extends NotionalAmountLeg2Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<BigDecimal> thenArg = MapperS.of(input)
				.mapSingleToItem(reportableEvent -> {
					final Boolean _boolean = isActionTypeTERM.evaluate(input);
					final MapperS<Trade> _thenArg;
					if ((_boolean == null ? false : _boolean)) {
						_thenArg = MapperS.of(beforeTradeForEvent.evaluate(input));
					} else {
						_thenArg = MapperS.of(tradeForEvent.evaluate(input));
					}
					return _thenArg
						.mapSingleToItem(item -> {
							if (areEqual(MapperS.of(qualify_InterestRate_Option_Swaption.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
								return MapperS.of(cDEInterestRateNotionalRule.evaluate(interestRateLeg2.evaluate(underlierForProduct.evaluate(productForTrade.evaluate(item.get())))));
							}
							if (ComparisonResult.of(MapperS.of(isFXForward.evaluate(productForTrade.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isFXOption.evaluate(productForTrade.evaluate(item.get()))))).getOrDefault(false)) {
								if (areEqual(MapperS.of(cDEFXNotionalRule.evaluate(fXLeg2.evaluate(productForTrade.evaluate(item.get())))), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
									return MapperS.of(new BigDecimal("99999999999999999999.99999"));
								}
								return MapperS.of(cDEFXNotionalRule.evaluate(fXLeg2.evaluate(productForTrade.evaluate(item.get()))));
							}
							final Boolean boolean0 = isFXSwap.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean0 == null ? false : boolean0)) {
								if (areEqual(MapperS.of(cDEFXNotionalRule.evaluate(fXSwapLeg2.evaluate(productForTrade.evaluate(item.get())))), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
									return MapperS.of(new BigDecimal("99999999999999999999.99999"));
								}
								return MapperS.of(cDEFXNotionalRule.evaluate(fXSwapLeg2.evaluate(productForTrade.evaluate(item.get()))));
							}
							final Boolean boolean1 = qualify_Commodity_Swap_FixedFloat.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
							if ((boolean1 == null ? false : boolean1)) {
								final ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule0 = MapperS.of(commodityLeg2.evaluate(productForTrade.evaluate(item.get()))).<ResolvablePriceQuantity>map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).get();
								final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule = MapperS.of(fixedPriceLeg1.evaluate(productForTrade.evaluate(item.get()))).<FixedPrice>map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).<ReferenceWithMetaPriceSchedule>map("getPrice", fixedPrice -> fixedPrice.getPrice()).get();
								return MapperS.of(cDECommodityNotional.evaluate((referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()), (referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue())));
							}
							final Boolean boolean2 = qualify_Commodity_Swap_Basis.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
							if ((boolean2 == null ? false : boolean2)) {
								if (exists(MapperS.of(lastAvailableSpotPrice.evaluate(reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get()))).getOrDefault(false)) {
									final ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule1 = MapperS.of(commodityBasisLegWithNoSpread.evaluate(productForTrade.evaluate(item.get()))).<ResolvablePriceQuantity>map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).get();
									return MapperS.of(cDECommodityNotional.evaluate((referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()), lastAvailableSpotPrice.evaluate(reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get())));
								}
								final MapperC<FieldWithMetaNonNegativeQuantitySchedule> thenArg0 = MapperS.of(commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg2.evaluate(productForTrade.evaluate(item.get())))).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity())
									.filterItemNullSafe(_item -> exists(_item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).get());
								final MapperC<BigDecimal> thenArg1 = thenArg0
									.mapItem(_item -> _item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
								return MapperS.of(thenArg1.get());
							}
							if (ComparisonResult.of(MapperS.of(qualify_AssetClass_InterestRate.evaluate(economicTermsForProduct.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())))).or(ComparisonResult.of(MapperS.of(qualify_AssetClass_Equity.evaluate(economicTermsForProduct.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get()))))).getOrDefault(false)) {
								return MapperS.of(cDEInterestRateNotionalRule.evaluate(interestRateLeg2.evaluate(productForTrade.evaluate(item.get()))));
							}
							return MapperS.<BigDecimal>ofNull();
						});
				});
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
