package drr.regulation.cftc.rewrite.reports;

import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;


@ImplementedBy(OtherPaymentPayerRule.OtherPaymentPayerRuleDefault.class)
public abstract class OtherPaymentPayerRule implements ReportFunction<TransferState, Void> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Void evaluate(TransferState input) {
		Void output = doEvaluate(input);
		
		return output;
	}

	protected abstract Void doEvaluate(TransferState input);

	public static class OtherPaymentPayerRuleDefault extends OtherPaymentPayerRule {
		@Override
		protected Void doEvaluate(TransferState input) {
			Void output = null;
			return assignOutput(output, input);
		}
		
		protected Void assignOutput(Void output, TransferState input) {
			output = null;
			
			return output;
		}
	}
}
