package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.functions.PayerPartyLeg1;
import drr.regulation.common.PartyIdentifierFormatEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.PartyIdentifierFormat;
import javax.inject.Inject;


@ImplementedBy(PayerLeg1IdentifierFormatRule.PayerLeg1IdentifierFormatRuleDefault.class)
public abstract class PayerLeg1IdentifierFormatRule implements ReportFunction<TransactionReportInstruction, PartyIdentifierFormatEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected PartyIdentifierFormat partyIdentifierFormat;
	@Inject protected PayerPartyLeg1 payerPartyLeg1;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PartyIdentifierFormatEnum evaluate(TransactionReportInstruction input) {
		PartyIdentifierFormatEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PartyIdentifierFormatEnum doEvaluate(TransactionReportInstruction input);

	public static class PayerLeg1IdentifierFormatRuleDefault extends PayerLeg1IdentifierFormatRule {
		@Override
		protected PartyIdentifierFormatEnum doEvaluate(TransactionReportInstruction input) {
			PartyIdentifierFormatEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PartyIdentifierFormatEnum assignOutput(PartyIdentifierFormatEnum output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(partyIdentifierFormat.evaluate(payerPartyLeg1.evaluate(item.get())))).get();
			
			return output;
		}
	}
}
