package drr.regulation.cftc.rewrite.reports;

import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.GetPriceNotationEnum;
import drr.regulation.common.functions.IsFixedFloatZeroCouponSwapKnownAmount;
import drr.regulation.common.functions.MultiplyPrice;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.reports.CDEPriceRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(PriceRule.PriceRuleDefault.class)
public abstract class PriceRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPriceRule cDEPriceRule;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected GetPriceNotationEnum getPriceNotationEnum;
	@Inject protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
	@Inject protected MultiplyPrice multiplyPrice;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
	@Inject protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class PriceRuleDefault extends PriceRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> ComparisonResult.of(MapperS.of(qualify_AssetClass_Commodity.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))))).or(ComparisonResult.of(MapperS.of(qualify_AssetClass_Equity.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get())))))).or(ComparisonResult.of(MapperS.of(isFixedFloatZeroCouponSwapKnownAmount.evaluate(productForEvent.evaluate(item.get()))))).get());
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(multiplyPrice.evaluate(cDEPriceRule.evaluate(item.get()), getPriceNotationEnum.evaluate(item.get())))).get();
			
			return output;
		}
	}
}
