package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PartyIdentifierFormatEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.PartyIdentifierFormat;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iosco.cde.functions.CDEDirection1SellerParty;
import javax.inject.Inject;


@ImplementedBy(SellerIdentifierFormatRule.SellerIdentifierFormatRuleDefault.class)
public abstract class SellerIdentifierFormatRule implements ReportFunction<TransactionReportInstruction, PartyIdentifierFormatEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEDirection1SellerParty cDEDirection1SellerParty;
	@Inject protected PartyIdentifierFormat partyIdentifierFormat;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PartyIdentifierFormatEnum evaluate(TransactionReportInstruction input) {
		PartyIdentifierFormatEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PartyIdentifierFormatEnum doEvaluate(TransactionReportInstruction input);

	public static class SellerIdentifierFormatRuleDefault extends SellerIdentifierFormatRule {
		@Override
		protected PartyIdentifierFormatEnum doEvaluate(TransactionReportInstruction input) {
			PartyIdentifierFormatEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PartyIdentifierFormatEnum assignOutput(PartyIdentifierFormatEnum output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(partyIdentifierFormat.evaluate(cDEDirection1SellerParty.evaluate(tradeForEvent.evaluate(item.get()))))).get();
			
			return output;
		}
	}
}
