package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.53.0
 */
@RosettaDataRule("CFTCGuidebookPart45LargeNotionalOffFacilitySwapElectionIndicator")
@ImplementedBy(CFTCGuidebookPart45LargeNotionalOffFacilitySwapElectionIndicator.Default.class)
public interface CFTCGuidebookPart45LargeNotionalOffFacilitySwapElectionIndicator extends Validator<CFTCGuidebookPart45> {
	
	String NAME = "CFTCGuidebookPart45LargeNotionalOffFacilitySwapElectionIndicator";
	String DEFINITION = "if sefOrDcmIndicator = True then largeNotionalOffFacilitySwapElectionIndicator is absent";
	
	class Default implements CFTCGuidebookPart45LargeNotionalOffFacilitySwapElectionIndicator {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCGuidebookPart45 cFTCGuidebookPart45) {
			ComparisonResult result = executeDataRule(cFTCGuidebookPart45);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCGuidebookPart45", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCGuidebookPart45", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCGuidebookPart45 cFTCGuidebookPart45) {
			try {
				if (areEqual(MapperS.of(cFTCGuidebookPart45).<Boolean>map("getSefOrDcmIndicator", _cFTCGuidebookPart45 -> _cFTCGuidebookPart45.getSefOrDcmIndicator()), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
					return notExists(MapperS.of(cFTCGuidebookPart45).<Boolean>map("getLargeNotionalOffFacilitySwapElectionIndicator", _cFTCGuidebookPart45 -> _cFTCGuidebookPart45.getLargeNotionalOffFacilitySwapElectionIndicator()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCGuidebookPart45LargeNotionalOffFacilitySwapElectionIndicator {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCGuidebookPart45 cFTCGuidebookPart45) {
			return Collections.emptyList();
		}
	}
}
