package drr.regulation.cftc.rewrite.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.53.0
 */
@RosettaDataRule("CFTCPart43TransactionReportCallCurrencyCondition")
@ImplementedBy(CFTCPart43TransactionReportCallCurrencyCondition.Default.class)
public interface CFTCPart43TransactionReportCallCurrencyCondition extends Validator<CFTCPart43TransactionReport> {
	
	String NAME = "CFTCPart43TransactionReportCallCurrencyCondition";
	String DEFINITION = "if callAmount exists then callCurrency exists else callCurrency is absent";
	
	class Default implements CFTCPart43TransactionReportCallCurrencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart43TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			try {
				if (exists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getCallAmount", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCallAmount())).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart43TransactionReport).<ISOCurrencyCodeEnum>map("getCallCurrency", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCallCurrency()));
				}
				return notExists(MapperS.of(cFTCPart43TransactionReport).<ISOCurrencyCodeEnum>map("getCallCurrency", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCallCurrency()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart43TransactionReportCallCurrencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			return Collections.emptyList();
		}
	}
}
