package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart43;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport;
import drr.regulation.cftc.rewrite.OtherPaymentReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.53.0
 */
@RosettaDataRule("CFTCPart43TransactionReportOtherPaymentTypeCondition")
@ImplementedBy(CFTCPart43TransactionReportOtherPaymentTypeCondition.Default.class)
public interface CFTCPart43TransactionReportOtherPaymentTypeCondition extends Validator<CFTCPart43TransactionReport> {
	
	String NAME = "CFTCPart43TransactionReportOtherPaymentTypeCondition";
	String DEFINITION = "if cftcGuidebook -> assetClass = \"Credit\" then (if fixedRateLeg1 is absent and fixedRateLeg2 is absent and spreadLeg1 is absent and spreadLeg2 is absent then otherPayment -> paymentType any = \"UFRO\")";
	
	class Default implements CFTCPart43TransactionReportOtherPaymentTypeCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart43TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			try {
				if (areEqual(MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebookPart43>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart43 -> cFTCGuidebookPart43.getAssetClass()), MapperS.of("Credit"), CardinalityOperator.All).getOrDefault(false)) {
					if (notExists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getFixedRateLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFixedRateLeg1())).and(notExists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getFixedRateLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFixedRateLeg2()))).and(notExists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getSpreadLeg1()))).and(notExists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getSpreadLeg2()))).getOrDefault(false)) {
						return areEqual(MapperS.of(cFTCPart43TransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getOtherPayment()).<String>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()), MapperS.of("UFRO"), CardinalityOperator.Any);
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart43TransactionReportOtherPaymentTypeCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			return Collections.emptyList();
		}
	}
}
