package drr.regulation.cftc.rewrite.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.cftc.rewrite.ClearingExceptionsAndExemptionsCounterparty1Report;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class ClearingExceptionsAndExemptionsCounterparty1ReportOnlyExistsValidator implements ValidatorWithArg<ClearingExceptionsAndExemptionsCounterparty1Report, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends ClearingExceptionsAndExemptionsCounterparty1Report> ValidationResult<ClearingExceptionsAndExemptionsCounterparty1Report> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("value", ExistenceChecker.isSet((String) o.getValue()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("ClearingExceptionsAndExemptionsCounterparty1Report", ValidationResult.ValidationType.ONLY_EXISTS, "ClearingExceptionsAndExemptionsCounterparty1Report", path, "");
		}
		return failure("ClearingExceptionsAndExemptionsCounterparty1Report", ValidationResult.ValidationType.ONLY_EXISTS, "ClearingExceptionsAndExemptionsCounterparty1Report", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
