package drr.regulation.cftc.tr.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.MandatorilyClearableEnum;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(MandatoryClearingIndicatorRule.MandatoryClearingIndicatorRuleDefault.class)
public abstract class MandatoryClearingIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class MandatoryClearingIndicatorRuleDefault extends MandatoryClearingIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			final MapperC<ReportingRegime> thenArg0 = MapperS.of(input)
				.mapSingleToList(item -> item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()));
			final MapperC<ReportingRegime> thenArg1 = thenArg0
				.filterItemNullSafe(item -> areEqual(item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.CFTC), CardinalityOperator.All).get());
			final MapperC<Boolean> thenArg2 = thenArg1
				.mapItem(item -> {
					if (areEqual(item.<MandatorilyClearableEnum>map("getMandatorilyClearable", reportingRegime -> reportingRegime.getMandatorilyClearable()), MapperS.of(MandatorilyClearableEnum.PRODUCT_AND_CPTY_MANDATORY), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(true);
					}
					if (areEqual(item.<MandatorilyClearableEnum>map("getMandatorilyClearable", reportingRegime -> reportingRegime.getMandatorilyClearable()), MapperS.of(MandatorilyClearableEnum.PRODUCT_MANDATORY_BUT_NOT_CPTY), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(false);
					}
					return MapperS.<Boolean>ofNull();
				});
			output = MapperS.of(distinct(thenArg2).get()).get();
			
			return output;
		}
	}
}
