package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.meta.ClearingExceptionReasonMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.53.0
 */
@RosettaDataType(value="ClearingExceptionReason", builder=ClearingExceptionReason.ClearingExceptionReasonBuilderImpl.class, version="5.53.0")
@RuneDataType(value="ClearingExceptionReason", model="drr", builder=ClearingExceptionReason.ClearingExceptionReasonBuilderImpl.class, version="5.53.0")
public interface ClearingExceptionReason extends RosettaModelObject {

	ClearingExceptionReasonMeta metaData = new ClearingExceptionReasonMeta();

	/*********************** Getter Methods  ***********************/
	ClearingExceptionReasonEnum getExceptionReason();

	/*********************** Build Methods  ***********************/
	ClearingExceptionReason build();
	
	ClearingExceptionReason.ClearingExceptionReasonBuilder toBuilder();
	
	static ClearingExceptionReason.ClearingExceptionReasonBuilder builder() {
		return new ClearingExceptionReason.ClearingExceptionReasonBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ClearingExceptionReason> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ClearingExceptionReason> getType() {
		return ClearingExceptionReason.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("exceptionReason"), ClearingExceptionReasonEnum.class, getExceptionReason(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ClearingExceptionReasonBuilder extends ClearingExceptionReason, RosettaModelObjectBuilder {
		ClearingExceptionReason.ClearingExceptionReasonBuilder setExceptionReason(ClearingExceptionReasonEnum exceptionReason);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("exceptionReason"), ClearingExceptionReasonEnum.class, getExceptionReason(), this);
		}
		

		ClearingExceptionReason.ClearingExceptionReasonBuilder prune();
	}

	/*********************** Immutable Implementation of ClearingExceptionReason  ***********************/
	class ClearingExceptionReasonImpl implements ClearingExceptionReason {
		private final ClearingExceptionReasonEnum exceptionReason;
		
		protected ClearingExceptionReasonImpl(ClearingExceptionReason.ClearingExceptionReasonBuilder builder) {
			this.exceptionReason = builder.getExceptionReason();
		}
		
		@Override
		@RosettaAttribute("exceptionReason")
		@RuneAttribute("exceptionReason")
		public ClearingExceptionReasonEnum getExceptionReason() {
			return exceptionReason;
		}
		
		@Override
		public ClearingExceptionReason build() {
			return this;
		}
		
		@Override
		public ClearingExceptionReason.ClearingExceptionReasonBuilder toBuilder() {
			ClearingExceptionReason.ClearingExceptionReasonBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ClearingExceptionReason.ClearingExceptionReasonBuilder builder) {
			ofNullable(getExceptionReason()).ifPresent(builder::setExceptionReason);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ClearingExceptionReason _that = getType().cast(o);
		
			if (!Objects.equals(exceptionReason, _that.getExceptionReason())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (exceptionReason != null ? exceptionReason.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ClearingExceptionReason {" +
				"exceptionReason=" + this.exceptionReason +
			'}';
		}
	}

	/*********************** Builder Implementation of ClearingExceptionReason  ***********************/
	class ClearingExceptionReasonBuilderImpl implements ClearingExceptionReason.ClearingExceptionReasonBuilder {
	
		protected ClearingExceptionReasonEnum exceptionReason;
		
		@Override
		@RosettaAttribute("exceptionReason")
		@RuneAttribute("exceptionReason")
		public ClearingExceptionReasonEnum getExceptionReason() {
			return exceptionReason;
		}
		
		@RosettaAttribute("exceptionReason")
		@RuneAttribute("exceptionReason")
		@Override
		public ClearingExceptionReason.ClearingExceptionReasonBuilder setExceptionReason(ClearingExceptionReasonEnum _exceptionReason) {
			this.exceptionReason = _exceptionReason == null ? null : _exceptionReason;
			return this;
		}
		
		@Override
		public ClearingExceptionReason build() {
			return new ClearingExceptionReason.ClearingExceptionReasonImpl(this);
		}
		
		@Override
		public ClearingExceptionReason.ClearingExceptionReasonBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ClearingExceptionReason.ClearingExceptionReasonBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getExceptionReason()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ClearingExceptionReason.ClearingExceptionReasonBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ClearingExceptionReason.ClearingExceptionReasonBuilder o = (ClearingExceptionReason.ClearingExceptionReasonBuilder) other;
			
			
			merger.mergeBasic(getExceptionReason(), o.getExceptionReason(), this::setExceptionReason);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ClearingExceptionReason _that = getType().cast(o);
		
			if (!Objects.equals(exceptionReason, _that.getExceptionReason())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (exceptionReason != null ? exceptionReason.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ClearingExceptionReasonBuilder {" +
				"exceptionReason=" + this.exceptionReason +
			'}';
		}
	}
}
