package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.meta.CommonTransactionInformationMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.53.0
 */
@RosettaDataType(value="CommonTransactionInformation", builder=CommonTransactionInformation.CommonTransactionInformationBuilderImpl.class, version="5.53.0")
@RuneDataType(value="CommonTransactionInformation", model="drr", builder=CommonTransactionInformation.CommonTransactionInformationBuilderImpl.class, version="5.53.0")
public interface CommonTransactionInformation extends RosettaModelObject {

	CommonTransactionInformationMeta metaData = new CommonTransactionInformationMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Whether the financial instrument is admitted to trading, or traded on a trading venue or for which a request for admission was made.
	 */
	AdmittedToTradingVenue getAdmittedToTradingVenue();
	/**
	 * Indicator of whether the product underlier of the reportable trade is traded on a trading venue.
	 */
	Boolean getUnderlierTradedOnTradingVenue();

	/*********************** Build Methods  ***********************/
	CommonTransactionInformation build();
	
	CommonTransactionInformation.CommonTransactionInformationBuilder toBuilder();
	
	static CommonTransactionInformation.CommonTransactionInformationBuilder builder() {
		return new CommonTransactionInformation.CommonTransactionInformationBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CommonTransactionInformation> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CommonTransactionInformation> getType() {
		return CommonTransactionInformation.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("admittedToTradingVenue"), AdmittedToTradingVenue.class, getAdmittedToTradingVenue(), this);
		processor.processBasic(path.newSubPath("underlierTradedOnTradingVenue"), Boolean.class, getUnderlierTradedOnTradingVenue(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CommonTransactionInformationBuilder extends CommonTransactionInformation, RosettaModelObjectBuilder {
		CommonTransactionInformation.CommonTransactionInformationBuilder setAdmittedToTradingVenue(AdmittedToTradingVenue admittedToTradingVenue);
		CommonTransactionInformation.CommonTransactionInformationBuilder setUnderlierTradedOnTradingVenue(Boolean underlierTradedOnTradingVenue);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("admittedToTradingVenue"), AdmittedToTradingVenue.class, getAdmittedToTradingVenue(), this);
			processor.processBasic(path.newSubPath("underlierTradedOnTradingVenue"), Boolean.class, getUnderlierTradedOnTradingVenue(), this);
		}
		

		CommonTransactionInformation.CommonTransactionInformationBuilder prune();
	}

	/*********************** Immutable Implementation of CommonTransactionInformation  ***********************/
	class CommonTransactionInformationImpl implements CommonTransactionInformation {
		private final AdmittedToTradingVenue admittedToTradingVenue;
		private final Boolean underlierTradedOnTradingVenue;
		
		protected CommonTransactionInformationImpl(CommonTransactionInformation.CommonTransactionInformationBuilder builder) {
			this.admittedToTradingVenue = builder.getAdmittedToTradingVenue();
			this.underlierTradedOnTradingVenue = builder.getUnderlierTradedOnTradingVenue();
		}
		
		@Override
		@RosettaAttribute("admittedToTradingVenue")
		@RuneAttribute("admittedToTradingVenue")
		public AdmittedToTradingVenue getAdmittedToTradingVenue() {
			return admittedToTradingVenue;
		}
		
		@Override
		@RosettaAttribute("underlierTradedOnTradingVenue")
		@RuneAttribute("underlierTradedOnTradingVenue")
		public Boolean getUnderlierTradedOnTradingVenue() {
			return underlierTradedOnTradingVenue;
		}
		
		@Override
		public CommonTransactionInformation build() {
			return this;
		}
		
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder toBuilder() {
			CommonTransactionInformation.CommonTransactionInformationBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CommonTransactionInformation.CommonTransactionInformationBuilder builder) {
			ofNullable(getAdmittedToTradingVenue()).ifPresent(builder::setAdmittedToTradingVenue);
			ofNullable(getUnderlierTradedOnTradingVenue()).ifPresent(builder::setUnderlierTradedOnTradingVenue);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CommonTransactionInformation _that = getType().cast(o);
		
			if (!Objects.equals(admittedToTradingVenue, _that.getAdmittedToTradingVenue())) return false;
			if (!Objects.equals(underlierTradedOnTradingVenue, _that.getUnderlierTradedOnTradingVenue())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (admittedToTradingVenue != null ? admittedToTradingVenue.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (underlierTradedOnTradingVenue != null ? underlierTradedOnTradingVenue.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CommonTransactionInformation {" +
				"admittedToTradingVenue=" + this.admittedToTradingVenue + ", " +
				"underlierTradedOnTradingVenue=" + this.underlierTradedOnTradingVenue +
			'}';
		}
	}

	/*********************** Builder Implementation of CommonTransactionInformation  ***********************/
	class CommonTransactionInformationBuilderImpl implements CommonTransactionInformation.CommonTransactionInformationBuilder {
	
		protected AdmittedToTradingVenue admittedToTradingVenue;
		protected Boolean underlierTradedOnTradingVenue;
		
		@Override
		@RosettaAttribute("admittedToTradingVenue")
		@RuneAttribute("admittedToTradingVenue")
		public AdmittedToTradingVenue getAdmittedToTradingVenue() {
			return admittedToTradingVenue;
		}
		
		@Override
		@RosettaAttribute("underlierTradedOnTradingVenue")
		@RuneAttribute("underlierTradedOnTradingVenue")
		public Boolean getUnderlierTradedOnTradingVenue() {
			return underlierTradedOnTradingVenue;
		}
		
		@RosettaAttribute("admittedToTradingVenue")
		@RuneAttribute("admittedToTradingVenue")
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder setAdmittedToTradingVenue(AdmittedToTradingVenue _admittedToTradingVenue) {
			this.admittedToTradingVenue = _admittedToTradingVenue == null ? null : _admittedToTradingVenue;
			return this;
		}
		
		@RosettaAttribute("underlierTradedOnTradingVenue")
		@RuneAttribute("underlierTradedOnTradingVenue")
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder setUnderlierTradedOnTradingVenue(Boolean _underlierTradedOnTradingVenue) {
			this.underlierTradedOnTradingVenue = _underlierTradedOnTradingVenue == null ? null : _underlierTradedOnTradingVenue;
			return this;
		}
		
		@Override
		public CommonTransactionInformation build() {
			return new CommonTransactionInformation.CommonTransactionInformationImpl(this);
		}
		
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getAdmittedToTradingVenue()!=null) return true;
			if (getUnderlierTradedOnTradingVenue()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CommonTransactionInformation.CommonTransactionInformationBuilder o = (CommonTransactionInformation.CommonTransactionInformationBuilder) other;
			
			
			merger.mergeBasic(getAdmittedToTradingVenue(), o.getAdmittedToTradingVenue(), this::setAdmittedToTradingVenue);
			merger.mergeBasic(getUnderlierTradedOnTradingVenue(), o.getUnderlierTradedOnTradingVenue(), this::setUnderlierTradedOnTradingVenue);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CommonTransactionInformation _that = getType().cast(o);
		
			if (!Objects.equals(admittedToTradingVenue, _that.getAdmittedToTradingVenue())) return false;
			if (!Objects.equals(underlierTradedOnTradingVenue, _that.getUnderlierTradedOnTradingVenue())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (admittedToTradingVenue != null ? admittedToTradingVenue.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (underlierTradedOnTradingVenue != null ? underlierTradedOnTradingVenue.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CommonTransactionInformationBuilder {" +
				"admittedToTradingVenue=" + this.admittedToTradingVenue + ", " +
				"underlierTradedOnTradingVenue=" + this.underlierTradedOnTradingVenue +
			'}';
		}
	}
}
