package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(AdjustPeriodMultiplier.AdjustPeriodMultiplierDefault.class)
public abstract class AdjustPeriodMultiplier implements RosettaFunction {

	/**
	* @param period 
	* @param periodMultiplier 
	* @return periodMultiplierValue 
	*/
	public BigDecimal evaluate(String period, BigDecimal periodMultiplier) {
		BigDecimal periodMultiplierValue = doEvaluate(period, periodMultiplier);
		
		return periodMultiplierValue;
	}

	protected abstract BigDecimal doEvaluate(String period, BigDecimal periodMultiplier);

	public static class AdjustPeriodMultiplierDefault extends AdjustPeriodMultiplier {
		@Override
		protected BigDecimal doEvaluate(String period, BigDecimal periodMultiplier) {
			BigDecimal periodMultiplierValue = null;
			return assignOutput(periodMultiplierValue, period, periodMultiplier);
		}
		
		protected BigDecimal assignOutput(BigDecimal periodMultiplierValue, String period, BigDecimal periodMultiplier) {
			if (areEqual(MapperS.of(period), MapperS.of("MNTH"), CardinalityOperator.All).and(areEqual(MapperS.of(periodMultiplier), MapperS.of(BigDecimal.valueOf(12)), CardinalityOperator.All)).getOrDefault(false)) {
				periodMultiplierValue = BigDecimal.valueOf(1);
			} else {
				periodMultiplierValue = periodMultiplier;
			}
			
			return periodMultiplierValue;
		}
	}
}
