package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.PriceReportablePeriod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(Create_ContinuousPriceSchedule.Create_ContinuousPriceScheduleDefault.class)
public abstract class Create_ContinuousPriceSchedule implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param reportablePeriod Input schedule may only have start dates specified, or may be discontinous.
	* @param endDate End date of the final period.
	* @return continuousReportablePeriod 
	*/
	public List<? extends PriceReportablePeriod> evaluate(List<? extends PriceReportablePeriod> reportablePeriod, Date endDate) {
		List<PriceReportablePeriod.PriceReportablePeriodBuilder> continuousReportablePeriodBuilder = doEvaluate(reportablePeriod, endDate);
		
		final List<? extends PriceReportablePeriod> continuousReportablePeriod;
		if (continuousReportablePeriodBuilder == null) {
			continuousReportablePeriod = null;
		} else {
			continuousReportablePeriod = continuousReportablePeriodBuilder.stream().map(PriceReportablePeriod::build).collect(Collectors.toList());
			objectValidator.validate(PriceReportablePeriod.class, continuousReportablePeriod);
		}
		
		return continuousReportablePeriod;
	}

	protected abstract List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(List<? extends PriceReportablePeriod> reportablePeriod, Date endDate);

	public static class Create_ContinuousPriceScheduleDefault extends Create_ContinuousPriceSchedule {
		@Override
		protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(List<? extends PriceReportablePeriod> reportablePeriod, Date endDate) {
			if (reportablePeriod == null) {
				reportablePeriod = Collections.emptyList();
			}
			List<PriceReportablePeriod.PriceReportablePeriodBuilder> continuousReportablePeriod = new ArrayList<>();
			return assignOutput(continuousReportablePeriod, reportablePeriod, endDate);
		}
		
		protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> assignOutput(List<PriceReportablePeriod.PriceReportablePeriodBuilder> continuousReportablePeriod, List<? extends PriceReportablePeriod> reportablePeriod, Date endDate) {
			return Optional.ofNullable(continuousReportablePeriod)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
