package drr.regulation.common.functions;

import cdm.base.datetime.Frequency;
import cdm.base.datetime.PeriodExtendedEnum;
import cdm.base.math.DatedValue;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FrequencyPeriod.FrequencyPeriodDefault.class)
public abstract class FrequencyPeriod implements RosettaFunction {

	/**
	* @param priceQuantity 
	* @param frequency 
	* @return period 
	*/
	public String evaluate(PriceQuantity priceQuantity, Frequency frequency) {
		String period = doEvaluate(priceQuantity, frequency);
		
		return period;
	}

	protected abstract String doEvaluate(PriceQuantity priceQuantity, Frequency frequency);

	protected abstract MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> quantity(PriceQuantity priceQuantity, Frequency frequency);

	public static class FrequencyPeriodDefault extends FrequencyPeriod {
		@Override
		protected String doEvaluate(PriceQuantity priceQuantity, Frequency frequency) {
			String period = null;
			return assignOutput(period, priceQuantity, frequency);
		}
		
		protected String assignOutput(String period, PriceQuantity priceQuantity, Frequency frequency) {
			if (areEqual(MapperS.of(frequency).<PeriodExtendedEnum>map("getPeriod", _frequency -> _frequency.getPeriod()), MapperS.of(PeriodExtendedEnum.D), CardinalityOperator.All).getOrDefault(false)) {
				period = "DAIL";
			} else if (areEqual(MapperS.of(frequency).<PeriodExtendedEnum>map("getPeriod", _frequency -> _frequency.getPeriod()), MapperS.of(PeriodExtendedEnum.W), CardinalityOperator.All).getOrDefault(false)) {
				period = "WEEK";
			} else if (areEqual(MapperS.of(frequency).<PeriodExtendedEnum>map("getPeriod", _frequency -> _frequency.getPeriod()), MapperS.of(PeriodExtendedEnum.M), CardinalityOperator.All).getOrDefault(false)) {
				period = "MNTH";
			} else if (areEqual(MapperS.of(frequency).<PeriodExtendedEnum>map("getPeriod", _frequency -> _frequency.getPeriod()), MapperS.of(PeriodExtendedEnum.Y), CardinalityOperator.All).getOrDefault(false)) {
				period = "YEAR";
			} else if (areEqual(MapperS.of(frequency).<PeriodExtendedEnum>map("getPeriod", _frequency -> _frequency.getPeriod()), MapperS.of(PeriodExtendedEnum.T), CardinalityOperator.All).getOrDefault(false)) {
				period = "EXPI";
			} else if (areEqual(MapperS.of(frequency).<PeriodExtendedEnum>map("getPeriod", _frequency -> _frequency.getPeriod()), MapperS.of(PeriodExtendedEnum.H), CardinalityOperator.All).getOrDefault(false)) {
				period = "HOUL";
			} else if (notExists(MapperS.of(frequency)).and(exists(quantity(priceQuantity, frequency))).getOrDefault(false)) {
				period = "ADHO";
			} else {
				period = null;
			}
			
			return period;
		}
		
		@Override
		protected MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> quantity(PriceQuantity priceQuantity, Frequency frequency) {
			return MapperS.of(priceQuantity).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", _priceQuantity -> _priceQuantity.getQuantity())
				.filterItemNullSafe(item -> exists(item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule0 -> fieldWithMetaNonNegativeQuantitySchedule0 == null ? null : fieldWithMetaNonNegativeQuantitySchedule0.getValue()).<Frequency>map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency())).and(exists(item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule1 -> fieldWithMetaNonNegativeQuantitySchedule1 == null ? null : fieldWithMetaNonNegativeQuantitySchedule1.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).or(areEqual(MapperS.of(distinct(item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule2 -> fieldWithMetaNonNegativeQuantitySchedule2 == null ? null : fieldWithMetaNonNegativeQuantitySchedule2.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).<BigDecimal>map("getValue", datedValue -> datedValue.getValue())).resultCount()), MapperS.of(1), CardinalityOperator.All))).get());
		}
	}
}
