package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.asset.BasketReferenceInformation;
import cdm.product.asset.BondReference;
import cdm.product.asset.CommodityPayout;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.CreditIndexReferenceInformation;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.GeneralTerms;
import cdm.product.asset.InflationRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.asset.ReferenceInformation;
import cdm.product.asset.ReferenceObligation;
import cdm.product.qualification.functions.Qualify_InterestRate_Fra;
import cdm.product.template.Basket;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetUnderlyingIdentificationType.GetUnderlyingIdentificationTypeDefault.class)
public abstract class GetUnderlyingIdentificationType implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected IsProductETD isProductETD;
	@Inject protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_InterestRate_Fra qualify_InterestRate_Fra;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param reportableEvent 
	* @return result 
	*/
	public String evaluate(ReportableEvent reportableEvent) {
		String result = doEvaluate(reportableEvent);
		
		return result;
	}

	protected abstract String doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends Product> product(ReportableEvent reportableEvent);

	public static class GetUnderlyingIdentificationTypeDefault extends GetUnderlyingIdentificationType {
		@Override
		protected String doEvaluate(ReportableEvent reportableEvent) {
			String result = null;
			return assignOutput(result, reportableEvent);
		}
		
		protected String assignOutput(String result, ReportableEvent reportableEvent) {
			if (areEqual(MapperS.of(underlierForProduct.evaluate(product(reportableEvent).get())).<Security>map("getSecurity", _product -> _product.getSecurity()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", security -> security.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.Any).and(notExists(MapperS.of(underlierForProduct.evaluate(product(reportableEvent).get())).<Security>map("getSecurity", _product -> _product.getSecurity()).<EconomicTerms>map("getEconomicTerms", security -> security.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<Index>map("getIndex", _product -> _product.getIndex()))).or(areEqual(MapperS.of(underlierForProduct.evaluate(product(reportableEvent).get())).<Loan>map("getLoan", _product -> _product.getLoan()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", loan -> loan.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.Any)).or(areEqual(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Security>map("getSecurity", _product -> _product.getSecurity()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", security -> security.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.Any)).or(areEqual(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Loan>map("getLoan", _product -> _product.getLoan()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", loan -> loan.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.Any)).or(areEqual(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).<ReferenceObligation>mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation()).<Security>map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", security -> security.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.Any)).or(areEqual(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).<ReferenceObligation>mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation()).<Loan>map("getLoan", referenceObligation -> referenceObligation.getLoan()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", loan -> loan.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.Any)).or(ComparisonResult.of(MapperS.of(isProductETD.evaluate(product(reportableEvent).get()))).and(areEqual(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", _referenceWithMetaCommodity -> _referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.Any).and(areEqual(MapperS.of(isSingleCommodityPayoutProduct.evaluate(product(reportableEvent).get())), MapperS.of(false), CardinalityOperator.All)).or(areEqual(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", _referenceWithMetaCommodity -> _referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.Any)).or(areEqual(MapperS.of(underlierForProduct.evaluate(product(reportableEvent).get())).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.Any)))).or(areEqual(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<BondReference>map("getBondReference", interestRatePayout -> interestRatePayout.getBondReference()).<ProductIdentifier>map("getBond", bondReference -> bondReference.getBond()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.Any)).getOrDefault(false)) {
				result = "I";
			} else if (exists(MapperS.of(underlierForProduct.evaluate(product(reportableEvent).get())).<Basket>map("getBasket", _product -> _product.getBasket())).or(exists(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Basket>map("getBasket", _product -> _product.getBasket()))).or(exists(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<BasketReferenceInformation>map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()))).or(exists(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product(reportableEvent).get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<BasketReferenceInformation>map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()))).or(ComparisonResult.of(MapperS.of(isProductETD.evaluate(product(reportableEvent).get()))).and(exists(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Basket>map("getBasket", _product -> _product.getBasket()))).and(areEqual(MapperS.of(isSingleCommodityPayoutProduct.evaluate(product(reportableEvent).get())), MapperS.of(false), CardinalityOperator.All))).getOrDefault(false)) {
				result = "B";
			} else if (exists(MapperS.of(underlierForProduct.evaluate(product(reportableEvent).get())).<Index>map("getIndex", _product -> _product.getIndex())).or(exists(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Index>map("getIndex", _product -> _product.getIndex()))).or(exists(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()))).or(exists(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product(reportableEvent).get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()))).or(exists(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()))).or(exists(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()))).or(ComparisonResult.of(MapperS.of(isProductETD.evaluate(product(reportableEvent).get()))).and(exists(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Index>map("getIndex", _product -> _product.getIndex()))).and(areEqual(MapperS.of(isSingleCommodityPayoutProduct.evaluate(product(reportableEvent).get())), MapperS.of(false), CardinalityOperator.All))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_Fra.evaluate(economicTermsForProduct.evaluate(product(reportableEvent).get()))))).or(ComparisonResult.of(MapperS.of(isProductETD.evaluate(product(reportableEvent).get()))).and(exists(MapperS.of(underlierForProduct.evaluate(underlierForProduct.evaluate(product(reportableEvent).get()))).<Index>map("getIndex", _product -> _product.getIndex())))).getOrDefault(false)) {
				result = "X";
			} else {
				result = null;
			}
			
			return result;
		}
		
		@Override
		protected MapperS<? extends Product> product(ReportableEvent reportableEvent) {
			if (ComparisonResult.of(MapperS.of(isCreditSwaption.evaluate(productForEvent.evaluate(reportableEvent)))).or(ComparisonResult.of(MapperS.of(isIRSwaption.evaluate(productForEvent.evaluate(reportableEvent))))).getOrDefault(false)) {
				return MapperS.of(underlierForProduct.evaluate(productForEvent.evaluate(reportableEvent)));
			}
			return MapperS.of(productForEvent.evaluate(reportableEvent));
		}
	}
}
