package drr.regulation.common.functions;

import cdm.event.common.ActionEnum;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableActionEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsActionTypeCORR.IsActionTypeCORRDefault.class)
public abstract class IsActionTypeCORR implements RosettaFunction {

	/**
	* @param reportableEvent 
	* @return isActionTypeCorr 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean isActionTypeCorr = doEvaluate(reportableEvent);
		
		return isActionTypeCorr;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<ActionEnum> workflowStepAction(ReportableEvent reportableEvent);

	protected abstract MapperS<ReportableActionEnum> reportingAction(ReportableEvent reportableEvent);

	public static class IsActionTypeCORRDefault extends IsActionTypeCORR {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean isActionTypeCorr = null;
			return assignOutput(isActionTypeCorr, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean isActionTypeCorr, ReportableEvent reportableEvent) {
			isActionTypeCorr = exists(reportingAction(reportableEvent)).and(areEqual(reportingAction(reportableEvent), MapperS.of(ReportableActionEnum.CORRECT), CardinalityOperator.All)).or(areEqual(workflowStepAction(reportableEvent), MapperS.of(ActionEnum.CORRECT), CardinalityOperator.All)).get();
			
			return isActionTypeCorr;
		}
		
		@Override
		protected MapperS<ActionEnum> workflowStepAction(ReportableEvent reportableEvent) {
			return MapperS.of(reportableEvent).<WorkflowStep>map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep()).<ActionEnum>map("getAction", workflowStep -> workflowStep.getAction());
		}
		
		@Override
		protected MapperS<ReportableActionEnum> reportingAction(ReportableEvent reportableEvent) {
			return MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<ReportableActionEnum>map("getReportableAction", reportableInformation -> reportableInformation.getReportableAction());
		}
	}
}
