package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.regulation.common.util.functions.StringContains;
import javax.inject.Inject;


@ImplementedBy(IsMax32UpperCaseAlphanumericText.IsMax32UpperCaseAlphanumericTextDefault.class)
public abstract class IsMax32UpperCaseAlphanumericText implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected StringContains stringContains;

	/**
	* @param text 
	* @return result 
	*/
	public Boolean evaluate(String text) {
		Boolean result = doEvaluate(text);
		
		return result;
	}

	protected abstract Boolean doEvaluate(String text);

	public static class IsMax32UpperCaseAlphanumericTextDefault extends IsMax32UpperCaseAlphanumericText {
		@Override
		protected Boolean doEvaluate(String text) {
			Boolean result = null;
			return assignOutput(result, text);
		}
		
		protected Boolean assignOutput(Boolean result, String text) {
			result = stringContains.evaluate(text, "^[A-Z0-9]{18}[0-9]{2}[A-Z0-9]{0,32}$");
			
			return result;
		}
	}
}
