package drr.regulation.common.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.ASICPartyInformation;
import drr.regulation.common.validation.ASICPartyInformationTypeFormatValidator;
import drr.regulation.common.validation.ASICPartyInformationValidator;
import drr.regulation.common.validation.exists.ASICPartyInformationOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.53.0
 */
@RosettaMeta(model=ASICPartyInformation.class)
public class ASICPartyInformationMeta implements RosettaMetaData<ASICPartyInformation> {

	@Override
	public List<Validator<? super ASICPartyInformation>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super ASICPartyInformation, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super ASICPartyInformation> validator(ValidatorFactory factory) {
		return factory.<ASICPartyInformation>create(ASICPartyInformationValidator.class);
	}

	@Override
	public Validator<? super ASICPartyInformation> typeFormatValidator(ValidatorFactory factory) {
		return factory.<ASICPartyInformation>create(ASICPartyInformationTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super ASICPartyInformation> validator() {
		return new ASICPartyInformationValidator();
	}

	@Deprecated
	@Override
	public Validator<? super ASICPartyInformation> typeFormatValidator() {
		return new ASICPartyInformationTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super ASICPartyInformation, Set<String>> onlyExistsValidator() {
		return new ASICPartyInformationOnlyExistsValidator();
	}
}
