package drr.regulation.common.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.CollateralDetails;
import drr.regulation.common.validation.CollateralDetailsTypeFormatValidator;
import drr.regulation.common.validation.CollateralDetailsValidator;
import drr.regulation.common.validation.exists.CollateralDetailsOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.53.0
 */
@RosettaMeta(model=CollateralDetails.class)
public class CollateralDetailsMeta implements RosettaMetaData<CollateralDetails> {

	@Override
	public List<Validator<? super CollateralDetails>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super CollateralDetails, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super CollateralDetails> validator(ValidatorFactory factory) {
		return factory.<CollateralDetails>create(CollateralDetailsValidator.class);
	}

	@Override
	public Validator<? super CollateralDetails> typeFormatValidator(ValidatorFactory factory) {
		return factory.<CollateralDetails>create(CollateralDetailsTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super CollateralDetails> validator() {
		return new CollateralDetailsValidator();
	}

	@Deprecated
	@Override
	public Validator<? super CollateralDetails> typeFormatValidator() {
		return new CollateralDetailsTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super CollateralDetails, Set<String>> onlyExistsValidator() {
		return new CollateralDetailsOnlyExistsValidator();
	}
}
