package drr.regulation.esma.emir.refit.margin;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.esma.emir.refit.margin.meta.PartiesToTheDerivativeMeta;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.53.0
 */
@RosettaDataType(value="PartiesToTheDerivative", builder=PartiesToTheDerivative.PartiesToTheDerivativeBuilderImpl.class, version="5.53.0")
@RuneDataType(value="PartiesToTheDerivative", model="drr", builder=PartiesToTheDerivative.PartiesToTheDerivativeBuilderImpl.class, version="5.53.0")
public interface PartiesToTheDerivative extends RosettaModelObject {

	PartiesToTheDerivativeMeta metaData = new PartiesToTheDerivativeMeta();

	/*********************** Getter Methods  ***********************/
	ZonedDateTime getReportingTimestamp();
	String getReportSubmittingEntityID();
	String getEntityResponsibleForReporting();
	String getCounterparty1();
	Boolean getCounterparty2IdentifierType();
	String getCounterparty2();
	ESMAEMIRNonReportableCollateralData getNonReportable();

	/*********************** Build Methods  ***********************/
	PartiesToTheDerivative build();
	
	PartiesToTheDerivative.PartiesToTheDerivativeBuilder toBuilder();
	
	static PartiesToTheDerivative.PartiesToTheDerivativeBuilder builder() {
		return new PartiesToTheDerivative.PartiesToTheDerivativeBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends PartiesToTheDerivative> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends PartiesToTheDerivative> getType() {
		return PartiesToTheDerivative.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
		processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processRosetta(path.newSubPath("nonReportable"), processor, ESMAEMIRNonReportableCollateralData.class, getNonReportable());
	}
	

	/*********************** Builder Interface  ***********************/
	interface PartiesToTheDerivativeBuilder extends PartiesToTheDerivative, RosettaModelObjectBuilder {
		ESMAEMIRNonReportableCollateralData.ESMAEMIRNonReportableCollateralDataBuilder getOrCreateNonReportable();
		@Override
		ESMAEMIRNonReportableCollateralData.ESMAEMIRNonReportableCollateralDataBuilder getNonReportable();
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder setReportSubmittingEntityID(String reportSubmittingEntityID);
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder setEntityResponsibleForReporting(String entityResponsibleForReporting);
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder setCounterparty1(String counterparty1);
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder setCounterparty2(String counterparty2);
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder setNonReportable(ESMAEMIRNonReportableCollateralData nonReportable);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
			processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processRosetta(path.newSubPath("nonReportable"), processor, ESMAEMIRNonReportableCollateralData.ESMAEMIRNonReportableCollateralDataBuilder.class, getNonReportable());
		}
		

		PartiesToTheDerivative.PartiesToTheDerivativeBuilder prune();
	}

	/*********************** Immutable Implementation of PartiesToTheDerivative  ***********************/
	class PartiesToTheDerivativeImpl implements PartiesToTheDerivative {
		private final ZonedDateTime reportingTimestamp;
		private final String reportSubmittingEntityID;
		private final String entityResponsibleForReporting;
		private final String counterparty1;
		private final Boolean counterparty2IdentifierType;
		private final String counterparty2;
		private final ESMAEMIRNonReportableCollateralData nonReportable;
		
		protected PartiesToTheDerivativeImpl(PartiesToTheDerivative.PartiesToTheDerivativeBuilder builder) {
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
			this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
			this.counterparty1 = builder.getCounterparty1();
			this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
			this.counterparty2 = builder.getCounterparty2();
			this.nonReportable = ofNullable(builder.getNonReportable()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		public String getReportSubmittingEntityID() {
			return reportSubmittingEntityID;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierType")
		@RuneAttribute("counterparty2IdentifierType")
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public ESMAEMIRNonReportableCollateralData getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public PartiesToTheDerivative build() {
			return this;
		}
		
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder toBuilder() {
			PartiesToTheDerivative.PartiesToTheDerivativeBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(PartiesToTheDerivative.PartiesToTheDerivativeBuilder builder) {
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityID);
			ofNullable(getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierType);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
			ofNullable(getNonReportable()).ifPresent(builder::setNonReportable);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PartiesToTheDerivative _that = getType().cast(o);
		
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(reportSubmittingEntityID, _that.getReportSubmittingEntityID())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportSubmittingEntityID != null ? reportSubmittingEntityID.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PartiesToTheDerivative {" +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"nonReportable=" + this.nonReportable +
			'}';
		}
	}

	/*********************** Builder Implementation of PartiesToTheDerivative  ***********************/
	class PartiesToTheDerivativeBuilderImpl implements PartiesToTheDerivative.PartiesToTheDerivativeBuilder {
	
		protected ZonedDateTime reportingTimestamp;
		protected String reportSubmittingEntityID;
		protected String entityResponsibleForReporting;
		protected String counterparty1;
		protected Boolean counterparty2IdentifierType;
		protected String counterparty2;
		protected ESMAEMIRNonReportableCollateralData.ESMAEMIRNonReportableCollateralDataBuilder nonReportable;
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		public String getReportSubmittingEntityID() {
			return reportSubmittingEntityID;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierType")
		@RuneAttribute("counterparty2IdentifierType")
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public ESMAEMIRNonReportableCollateralData.ESMAEMIRNonReportableCollateralDataBuilder getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public ESMAEMIRNonReportableCollateralData.ESMAEMIRNonReportableCollateralDataBuilder getOrCreateNonReportable() {
			ESMAEMIRNonReportableCollateralData.ESMAEMIRNonReportableCollateralDataBuilder result;
			if (nonReportable!=null) {
				result = nonReportable;
			}
			else {
				result = nonReportable = ESMAEMIRNonReportableCollateralData.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
			this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
			return this;
		}
		
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
			this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
			return this;
		}
		
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@RosettaAttribute("counterparty2IdentifierType")
		@RuneAttribute("counterparty2IdentifierType")
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder setNonReportable(ESMAEMIRNonReportableCollateralData _nonReportable) {
			this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
			return this;
		}
		
		@Override
		public PartiesToTheDerivative build() {
			return new PartiesToTheDerivative.PartiesToTheDerivativeImpl(this);
		}
		
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder prune() {
			if (nonReportable!=null && !nonReportable.prune().hasData()) nonReportable = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getReportingTimestamp()!=null) return true;
			if (getReportSubmittingEntityID()!=null) return true;
			if (getEntityResponsibleForReporting()!=null) return true;
			if (getCounterparty1()!=null) return true;
			if (getCounterparty2IdentifierType()!=null) return true;
			if (getCounterparty2()!=null) return true;
			if (getNonReportable()!=null && getNonReportable().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			PartiesToTheDerivative.PartiesToTheDerivativeBuilder o = (PartiesToTheDerivative.PartiesToTheDerivativeBuilder) other;
			
			merger.mergeRosetta(getNonReportable(), o.getNonReportable(), this::setNonReportable);
			
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getReportSubmittingEntityID(), o.getReportSubmittingEntityID(), this::setReportSubmittingEntityID);
			merger.mergeBasic(getEntityResponsibleForReporting(), o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting);
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getCounterparty2IdentifierType(), o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierType);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PartiesToTheDerivative _that = getType().cast(o);
		
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(reportSubmittingEntityID, _that.getReportSubmittingEntityID())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportSubmittingEntityID != null ? reportSubmittingEntityID.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PartiesToTheDerivativeBuilder {" +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"nonReportable=" + this.nonReportable +
			'}';
		}
	}
}
