package drr.regulation.esma.emir.refit.margin.reports;

import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.RoundToPrecision;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;
import drr.standards.iosco.cde.reports.CDEExcessCollateralCollectedByTheReportingCounterpartyRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(ExcessCollateralCollectedByTheCounterparty1Rule.ExcessCollateralCollectedByTheCounterparty1RuleDefault.class)
public abstract class ExcessCollateralCollectedByTheCounterparty1Rule implements ReportFunction<CollateralReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEExcessCollateralCollectedByTheReportingCounterpartyRule cDEExcessCollateralCollectedByTheReportingCounterpartyRule;
	@Inject protected RoundToPrecision roundToPrecision;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(CollateralReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(CollateralReportInstruction input);

	public static class ExcessCollateralCollectedByTheCounterparty1RuleDefault extends ExcessCollateralCollectedByTheCounterparty1Rule {
		@Override
		protected BigDecimal doEvaluate(CollateralReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, CollateralReportInstruction input) {
			final MapperS<BigDecimal> thenArg = MapperS.of(cDEExcessCollateralCollectedByTheReportingCounterpartyRule.evaluate(input));
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(roundToPrecision.evaluate(item.get(), 5, RoundingDirectionEnum.NEAREST))).get();
			
			return output;
		}
	}
}
