package drr.regulation.esma.emir.refit.trade;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.esma.emir.refit.trade.meta.PackageTransactionPriceMeta;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.53.0
 */
@RosettaDataType(value="PackageTransactionPrice", builder=PackageTransactionPrice.PackageTransactionPriceBuilderImpl.class, version="5.53.0")
@RuneDataType(value="PackageTransactionPrice", model="drr", builder=PackageTransactionPrice.PackageTransactionPriceBuilderImpl.class, version="5.53.0")
public interface PackageTransactionPrice extends RosettaModelObject {

	PackageTransactionPriceMeta metaData = new PackageTransactionPriceMeta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getPackageTransactionPriceMonetary();
	BigDecimal getPackageTransactionPricePercentage();
	BigDecimal getPackageTransactionPriceBasis();
	PriceNotationEnum getPackageTransactionPriceNotation();
	ISOCurrencyCodeEnum getPackageTransactionPriceCurrency();

	/*********************** Build Methods  ***********************/
	PackageTransactionPrice build();
	
	PackageTransactionPrice.PackageTransactionPriceBuilder toBuilder();
	
	static PackageTransactionPrice.PackageTransactionPriceBuilder builder() {
		return new PackageTransactionPrice.PackageTransactionPriceBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends PackageTransactionPrice> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends PackageTransactionPrice> getType() {
		return PackageTransactionPrice.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("packageTransactionPriceMonetary"), BigDecimal.class, getPackageTransactionPriceMonetary(), this);
		processor.processBasic(path.newSubPath("packageTransactionPricePercentage"), BigDecimal.class, getPackageTransactionPricePercentage(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceBasis"), BigDecimal.class, getPackageTransactionPriceBasis(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface PackageTransactionPriceBuilder extends PackageTransactionPrice, RosettaModelObjectBuilder {
		PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceMonetary(BigDecimal packageTransactionPriceMonetary);
		PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPricePercentage(BigDecimal packageTransactionPricePercentage);
		PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceBasis(BigDecimal packageTransactionPriceBasis);
		PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceNotation(PriceNotationEnum packageTransactionPriceNotation);
		PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum packageTransactionPriceCurrency);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("packageTransactionPriceMonetary"), BigDecimal.class, getPackageTransactionPriceMonetary(), this);
			processor.processBasic(path.newSubPath("packageTransactionPricePercentage"), BigDecimal.class, getPackageTransactionPricePercentage(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceBasis"), BigDecimal.class, getPackageTransactionPriceBasis(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
		}
		

		PackageTransactionPrice.PackageTransactionPriceBuilder prune();
	}

	/*********************** Immutable Implementation of PackageTransactionPrice  ***********************/
	class PackageTransactionPriceImpl implements PackageTransactionPrice {
		private final BigDecimal packageTransactionPriceMonetary;
		private final BigDecimal packageTransactionPricePercentage;
		private final BigDecimal packageTransactionPriceBasis;
		private final PriceNotationEnum packageTransactionPriceNotation;
		private final ISOCurrencyCodeEnum packageTransactionPriceCurrency;
		
		protected PackageTransactionPriceImpl(PackageTransactionPrice.PackageTransactionPriceBuilder builder) {
			this.packageTransactionPriceMonetary = builder.getPackageTransactionPriceMonetary();
			this.packageTransactionPricePercentage = builder.getPackageTransactionPricePercentage();
			this.packageTransactionPriceBasis = builder.getPackageTransactionPriceBasis();
			this.packageTransactionPriceNotation = builder.getPackageTransactionPriceNotation();
			this.packageTransactionPriceCurrency = builder.getPackageTransactionPriceCurrency();
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceMonetary")
		@RuneAttribute("packageTransactionPriceMonetary")
		public BigDecimal getPackageTransactionPriceMonetary() {
			return packageTransactionPriceMonetary;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPricePercentage")
		@RuneAttribute("packageTransactionPricePercentage")
		public BigDecimal getPackageTransactionPricePercentage() {
			return packageTransactionPricePercentage;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceBasis")
		@RuneAttribute("packageTransactionPriceBasis")
		public BigDecimal getPackageTransactionPriceBasis() {
			return packageTransactionPriceBasis;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		public PriceNotationEnum getPackageTransactionPriceNotation() {
			return packageTransactionPriceNotation;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		public ISOCurrencyCodeEnum getPackageTransactionPriceCurrency() {
			return packageTransactionPriceCurrency;
		}
		
		@Override
		public PackageTransactionPrice build() {
			return this;
		}
		
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder toBuilder() {
			PackageTransactionPrice.PackageTransactionPriceBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(PackageTransactionPrice.PackageTransactionPriceBuilder builder) {
			ofNullable(getPackageTransactionPriceMonetary()).ifPresent(builder::setPackageTransactionPriceMonetary);
			ofNullable(getPackageTransactionPricePercentage()).ifPresent(builder::setPackageTransactionPricePercentage);
			ofNullable(getPackageTransactionPriceBasis()).ifPresent(builder::setPackageTransactionPriceBasis);
			ofNullable(getPackageTransactionPriceNotation()).ifPresent(builder::setPackageTransactionPriceNotation);
			ofNullable(getPackageTransactionPriceCurrency()).ifPresent(builder::setPackageTransactionPriceCurrency);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PackageTransactionPrice _that = getType().cast(o);
		
			if (!Objects.equals(packageTransactionPriceMonetary, _that.getPackageTransactionPriceMonetary())) return false;
			if (!Objects.equals(packageTransactionPricePercentage, _that.getPackageTransactionPricePercentage())) return false;
			if (!Objects.equals(packageTransactionPriceBasis, _that.getPackageTransactionPriceBasis())) return false;
			if (!Objects.equals(packageTransactionPriceNotation, _that.getPackageTransactionPriceNotation())) return false;
			if (!Objects.equals(packageTransactionPriceCurrency, _that.getPackageTransactionPriceCurrency())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (packageTransactionPriceMonetary != null ? packageTransactionPriceMonetary.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPricePercentage != null ? packageTransactionPricePercentage.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceBasis != null ? packageTransactionPriceBasis.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceNotation != null ? packageTransactionPriceNotation.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceCurrency != null ? packageTransactionPriceCurrency.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PackageTransactionPrice {" +
				"packageTransactionPriceMonetary=" + this.packageTransactionPriceMonetary + ", " +
				"packageTransactionPricePercentage=" + this.packageTransactionPricePercentage + ", " +
				"packageTransactionPriceBasis=" + this.packageTransactionPriceBasis + ", " +
				"packageTransactionPriceNotation=" + this.packageTransactionPriceNotation + ", " +
				"packageTransactionPriceCurrency=" + this.packageTransactionPriceCurrency +
			'}';
		}
	}

	/*********************** Builder Implementation of PackageTransactionPrice  ***********************/
	class PackageTransactionPriceBuilderImpl implements PackageTransactionPrice.PackageTransactionPriceBuilder {
	
		protected BigDecimal packageTransactionPriceMonetary;
		protected BigDecimal packageTransactionPricePercentage;
		protected BigDecimal packageTransactionPriceBasis;
		protected PriceNotationEnum packageTransactionPriceNotation;
		protected ISOCurrencyCodeEnum packageTransactionPriceCurrency;
		
		@Override
		@RosettaAttribute("packageTransactionPriceMonetary")
		@RuneAttribute("packageTransactionPriceMonetary")
		public BigDecimal getPackageTransactionPriceMonetary() {
			return packageTransactionPriceMonetary;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPricePercentage")
		@RuneAttribute("packageTransactionPricePercentage")
		public BigDecimal getPackageTransactionPricePercentage() {
			return packageTransactionPricePercentage;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceBasis")
		@RuneAttribute("packageTransactionPriceBasis")
		public BigDecimal getPackageTransactionPriceBasis() {
			return packageTransactionPriceBasis;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		public PriceNotationEnum getPackageTransactionPriceNotation() {
			return packageTransactionPriceNotation;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		public ISOCurrencyCodeEnum getPackageTransactionPriceCurrency() {
			return packageTransactionPriceCurrency;
		}
		
		@RosettaAttribute("packageTransactionPriceMonetary")
		@RuneAttribute("packageTransactionPriceMonetary")
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceMonetary(BigDecimal _packageTransactionPriceMonetary) {
			this.packageTransactionPriceMonetary = _packageTransactionPriceMonetary == null ? null : _packageTransactionPriceMonetary;
			return this;
		}
		
		@RosettaAttribute("packageTransactionPricePercentage")
		@RuneAttribute("packageTransactionPricePercentage")
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPricePercentage(BigDecimal _packageTransactionPricePercentage) {
			this.packageTransactionPricePercentage = _packageTransactionPricePercentage == null ? null : _packageTransactionPricePercentage;
			return this;
		}
		
		@RosettaAttribute("packageTransactionPriceBasis")
		@RuneAttribute("packageTransactionPriceBasis")
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceBasis(BigDecimal _packageTransactionPriceBasis) {
			this.packageTransactionPriceBasis = _packageTransactionPriceBasis == null ? null : _packageTransactionPriceBasis;
			return this;
		}
		
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
			this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
			return this;
		}
		
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
			this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
			return this;
		}
		
		@Override
		public PackageTransactionPrice build() {
			return new PackageTransactionPrice.PackageTransactionPriceImpl(this);
		}
		
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getPackageTransactionPriceMonetary()!=null) return true;
			if (getPackageTransactionPricePercentage()!=null) return true;
			if (getPackageTransactionPriceBasis()!=null) return true;
			if (getPackageTransactionPriceNotation()!=null) return true;
			if (getPackageTransactionPriceCurrency()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			PackageTransactionPrice.PackageTransactionPriceBuilder o = (PackageTransactionPrice.PackageTransactionPriceBuilder) other;
			
			
			merger.mergeBasic(getPackageTransactionPriceMonetary(), o.getPackageTransactionPriceMonetary(), this::setPackageTransactionPriceMonetary);
			merger.mergeBasic(getPackageTransactionPricePercentage(), o.getPackageTransactionPricePercentage(), this::setPackageTransactionPricePercentage);
			merger.mergeBasic(getPackageTransactionPriceBasis(), o.getPackageTransactionPriceBasis(), this::setPackageTransactionPriceBasis);
			merger.mergeBasic(getPackageTransactionPriceNotation(), o.getPackageTransactionPriceNotation(), this::setPackageTransactionPriceNotation);
			merger.mergeBasic(getPackageTransactionPriceCurrency(), o.getPackageTransactionPriceCurrency(), this::setPackageTransactionPriceCurrency);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PackageTransactionPrice _that = getType().cast(o);
		
			if (!Objects.equals(packageTransactionPriceMonetary, _that.getPackageTransactionPriceMonetary())) return false;
			if (!Objects.equals(packageTransactionPricePercentage, _that.getPackageTransactionPricePercentage())) return false;
			if (!Objects.equals(packageTransactionPriceBasis, _that.getPackageTransactionPriceBasis())) return false;
			if (!Objects.equals(packageTransactionPriceNotation, _that.getPackageTransactionPriceNotation())) return false;
			if (!Objects.equals(packageTransactionPriceCurrency, _that.getPackageTransactionPriceCurrency())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (packageTransactionPriceMonetary != null ? packageTransactionPriceMonetary.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPricePercentage != null ? packageTransactionPricePercentage.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceBasis != null ? packageTransactionPriceBasis.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceNotation != null ? packageTransactionPriceNotation.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceCurrency != null ? packageTransactionPriceCurrency.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PackageTransactionPriceBuilder {" +
				"packageTransactionPriceMonetary=" + this.packageTransactionPriceMonetary + ", " +
				"packageTransactionPricePercentage=" + this.packageTransactionPricePercentage + ", " +
				"packageTransactionPriceBasis=" + this.packageTransactionPriceBasis + ", " +
				"packageTransactionPriceNotation=" + this.packageTransactionPriceNotation + ", " +
				"packageTransactionPriceCurrency=" + this.packageTransactionPriceCurrency +
			'}';
		}
	}
}
