package drr.regulation.esma.emir.refit.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.esma.emir.refit.trade.meta.StrikePriceAndNotationMeta;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.53.0
 */
@RosettaDataType(value="StrikePriceAndNotation", builder=StrikePriceAndNotation.StrikePriceAndNotationBuilderImpl.class, version="5.53.0")
@RuneDataType(value="StrikePriceAndNotation", model="drr", builder=StrikePriceAndNotation.StrikePriceAndNotationBuilderImpl.class, version="5.53.0")
public interface StrikePriceAndNotation extends RosettaModelObject {

	StrikePriceAndNotationMeta metaData = new StrikePriceAndNotationMeta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getStrikePriceMonetary();
	BigDecimal getStrikePricePercentage();
	String getStrikePriceCurrency();
	PriceNotationEnum getStrikePriceNotation();

	/*********************** Build Methods  ***********************/
	StrikePriceAndNotation build();
	
	StrikePriceAndNotation.StrikePriceAndNotationBuilder toBuilder();
	
	static StrikePriceAndNotation.StrikePriceAndNotationBuilder builder() {
		return new StrikePriceAndNotation.StrikePriceAndNotationBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends StrikePriceAndNotation> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends StrikePriceAndNotation> getType() {
		return StrikePriceAndNotation.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("strikePriceMonetary"), BigDecimal.class, getStrikePriceMonetary(), this);
		processor.processBasic(path.newSubPath("strikePricePercentage"), BigDecimal.class, getStrikePricePercentage(), this);
		processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
		processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface StrikePriceAndNotationBuilder extends StrikePriceAndNotation, RosettaModelObjectBuilder {
		StrikePriceAndNotation.StrikePriceAndNotationBuilder setStrikePriceMonetary(BigDecimal strikePriceMonetary);
		StrikePriceAndNotation.StrikePriceAndNotationBuilder setStrikePricePercentage(BigDecimal strikePricePercentage);
		StrikePriceAndNotation.StrikePriceAndNotationBuilder setStrikePriceCurrency(String strikePriceCurrency);
		StrikePriceAndNotation.StrikePriceAndNotationBuilder setStrikePriceNotation(PriceNotationEnum strikePriceNotation);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("strikePriceMonetary"), BigDecimal.class, getStrikePriceMonetary(), this);
			processor.processBasic(path.newSubPath("strikePricePercentage"), BigDecimal.class, getStrikePricePercentage(), this);
			processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
			processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
		}
		

		StrikePriceAndNotation.StrikePriceAndNotationBuilder prune();
	}

	/*********************** Immutable Implementation of StrikePriceAndNotation  ***********************/
	class StrikePriceAndNotationImpl implements StrikePriceAndNotation {
		private final BigDecimal strikePriceMonetary;
		private final BigDecimal strikePricePercentage;
		private final String strikePriceCurrency;
		private final PriceNotationEnum strikePriceNotation;
		
		protected StrikePriceAndNotationImpl(StrikePriceAndNotation.StrikePriceAndNotationBuilder builder) {
			this.strikePriceMonetary = builder.getStrikePriceMonetary();
			this.strikePricePercentage = builder.getStrikePricePercentage();
			this.strikePriceCurrency = builder.getStrikePriceCurrency();
			this.strikePriceNotation = builder.getStrikePriceNotation();
		}
		
		@Override
		@RosettaAttribute("strikePriceMonetary")
		@RuneAttribute("strikePriceMonetary")
		public BigDecimal getStrikePriceMonetary() {
			return strikePriceMonetary;
		}
		
		@Override
		@RosettaAttribute("strikePricePercentage")
		@RuneAttribute("strikePricePercentage")
		public BigDecimal getStrikePricePercentage() {
			return strikePricePercentage;
		}
		
		@Override
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		public String getStrikePriceCurrency() {
			return strikePriceCurrency;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		public PriceNotationEnum getStrikePriceNotation() {
			return strikePriceNotation;
		}
		
		@Override
		public StrikePriceAndNotation build() {
			return this;
		}
		
		@Override
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder toBuilder() {
			StrikePriceAndNotation.StrikePriceAndNotationBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(StrikePriceAndNotation.StrikePriceAndNotationBuilder builder) {
			ofNullable(getStrikePriceMonetary()).ifPresent(builder::setStrikePriceMonetary);
			ofNullable(getStrikePricePercentage()).ifPresent(builder::setStrikePricePercentage);
			ofNullable(getStrikePriceCurrency()).ifPresent(builder::setStrikePriceCurrency);
			ofNullable(getStrikePriceNotation()).ifPresent(builder::setStrikePriceNotation);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			StrikePriceAndNotation _that = getType().cast(o);
		
			if (!Objects.equals(strikePriceMonetary, _that.getStrikePriceMonetary())) return false;
			if (!Objects.equals(strikePricePercentage, _that.getStrikePricePercentage())) return false;
			if (!Objects.equals(strikePriceCurrency, _that.getStrikePriceCurrency())) return false;
			if (!Objects.equals(strikePriceNotation, _that.getStrikePriceNotation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (strikePriceMonetary != null ? strikePriceMonetary.hashCode() : 0);
			_result = 31 * _result + (strikePricePercentage != null ? strikePricePercentage.hashCode() : 0);
			_result = 31 * _result + (strikePriceCurrency != null ? strikePriceCurrency.hashCode() : 0);
			_result = 31 * _result + (strikePriceNotation != null ? strikePriceNotation.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "StrikePriceAndNotation {" +
				"strikePriceMonetary=" + this.strikePriceMonetary + ", " +
				"strikePricePercentage=" + this.strikePricePercentage + ", " +
				"strikePriceCurrency=" + this.strikePriceCurrency + ", " +
				"strikePriceNotation=" + this.strikePriceNotation +
			'}';
		}
	}

	/*********************** Builder Implementation of StrikePriceAndNotation  ***********************/
	class StrikePriceAndNotationBuilderImpl implements StrikePriceAndNotation.StrikePriceAndNotationBuilder {
	
		protected BigDecimal strikePriceMonetary;
		protected BigDecimal strikePricePercentage;
		protected String strikePriceCurrency;
		protected PriceNotationEnum strikePriceNotation;
		
		@Override
		@RosettaAttribute("strikePriceMonetary")
		@RuneAttribute("strikePriceMonetary")
		public BigDecimal getStrikePriceMonetary() {
			return strikePriceMonetary;
		}
		
		@Override
		@RosettaAttribute("strikePricePercentage")
		@RuneAttribute("strikePricePercentage")
		public BigDecimal getStrikePricePercentage() {
			return strikePricePercentage;
		}
		
		@Override
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		public String getStrikePriceCurrency() {
			return strikePriceCurrency;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		public PriceNotationEnum getStrikePriceNotation() {
			return strikePriceNotation;
		}
		
		@RosettaAttribute("strikePriceMonetary")
		@RuneAttribute("strikePriceMonetary")
		@Override
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder setStrikePriceMonetary(BigDecimal _strikePriceMonetary) {
			this.strikePriceMonetary = _strikePriceMonetary == null ? null : _strikePriceMonetary;
			return this;
		}
		
		@RosettaAttribute("strikePricePercentage")
		@RuneAttribute("strikePricePercentage")
		@Override
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder setStrikePricePercentage(BigDecimal _strikePricePercentage) {
			this.strikePricePercentage = _strikePricePercentage == null ? null : _strikePricePercentage;
			return this;
		}
		
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		@Override
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
			this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
			return this;
		}
		
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		@Override
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
			this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
			return this;
		}
		
		@Override
		public StrikePriceAndNotation build() {
			return new StrikePriceAndNotation.StrikePriceAndNotationImpl(this);
		}
		
		@Override
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getStrikePriceMonetary()!=null) return true;
			if (getStrikePricePercentage()!=null) return true;
			if (getStrikePriceCurrency()!=null) return true;
			if (getStrikePriceNotation()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			StrikePriceAndNotation.StrikePriceAndNotationBuilder o = (StrikePriceAndNotation.StrikePriceAndNotationBuilder) other;
			
			
			merger.mergeBasic(getStrikePriceMonetary(), o.getStrikePriceMonetary(), this::setStrikePriceMonetary);
			merger.mergeBasic(getStrikePricePercentage(), o.getStrikePricePercentage(), this::setStrikePricePercentage);
			merger.mergeBasic(getStrikePriceCurrency(), o.getStrikePriceCurrency(), this::setStrikePriceCurrency);
			merger.mergeBasic(getStrikePriceNotation(), o.getStrikePriceNotation(), this::setStrikePriceNotation);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			StrikePriceAndNotation _that = getType().cast(o);
		
			if (!Objects.equals(strikePriceMonetary, _that.getStrikePriceMonetary())) return false;
			if (!Objects.equals(strikePricePercentage, _that.getStrikePricePercentage())) return false;
			if (!Objects.equals(strikePriceCurrency, _that.getStrikePriceCurrency())) return false;
			if (!Objects.equals(strikePriceNotation, _that.getStrikePriceNotation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (strikePriceMonetary != null ? strikePriceMonetary.hashCode() : 0);
			_result = 31 * _result + (strikePricePercentage != null ? strikePricePercentage.hashCode() : 0);
			_result = 31 * _result + (strikePriceCurrency != null ? strikePriceCurrency.hashCode() : 0);
			_result = 31 * _result + (strikePriceNotation != null ? strikePriceNotation.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "StrikePriceAndNotationBuilder {" +
				"strikePriceMonetary=" + this.strikePriceMonetary + ", " +
				"strikePricePercentage=" + this.strikePricePercentage + ", " +
				"strikePriceCurrency=" + this.strikePriceCurrency + ", " +
				"strikePriceNotation=" + this.strikePriceNotation +
			'}';
		}
	}
}
