package drr.regulation.esma.emir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.Create_ContinuousPriceSchedule;
import drr.regulation.common.functions.GetExpirationDate;
import drr.regulation.common.functions.GetReportableStrikePricePeriod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(EUEMIRReportableStrikePricePeriod.EUEMIRReportableStrikePricePeriodDefault.class)
public abstract class EUEMIRReportableStrikePricePeriod implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_ContinuousPriceSchedule create_ContinuousPriceSchedule;
	@Inject protected GetExpirationDate getExpirationDate;
	@Inject protected GetReportableStrikePricePeriod getReportableStrikePricePeriod;

	/**
	* @param transactionReportInstruction 
	* @return emirReportableStrikePricePeriods 
	*/
	public List<? extends PriceReportablePeriod> evaluate(TransactionReportInstruction transactionReportInstruction) {
		List<PriceReportablePeriod.PriceReportablePeriodBuilder> emirReportableStrikePricePeriodsBuilder = doEvaluate(transactionReportInstruction);
		
		final List<? extends PriceReportablePeriod> emirReportableStrikePricePeriods;
		if (emirReportableStrikePricePeriodsBuilder == null) {
			emirReportableStrikePricePeriods = null;
		} else {
			emirReportableStrikePricePeriods = emirReportableStrikePricePeriodsBuilder.stream().map(PriceReportablePeriod::build).collect(Collectors.toList());
			objectValidator.validate(PriceReportablePeriod.class, emirReportableStrikePricePeriods);
		}
		
		return emirReportableStrikePricePeriods;
	}

	protected abstract List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<Date> expirationDate(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperC<? extends PriceReportablePeriod> genericReportableStrikePriceSchedule(TransactionReportInstruction transactionReportInstruction);

	public static class EUEMIRReportableStrikePricePeriodDefault extends EUEMIRReportableStrikePricePeriod {
		@Override
		protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(TransactionReportInstruction transactionReportInstruction) {
			List<PriceReportablePeriod.PriceReportablePeriodBuilder> emirReportableStrikePricePeriods = new ArrayList<>();
			return assignOutput(emirReportableStrikePricePeriods, transactionReportInstruction);
		}
		
		protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> assignOutput(List<PriceReportablePeriod.PriceReportablePeriodBuilder> emirReportableStrikePricePeriods, TransactionReportInstruction transactionReportInstruction) {
			emirReportableStrikePricePeriods = toBuilder(create_ContinuousPriceSchedule.evaluate(genericReportableStrikePriceSchedule(transactionReportInstruction).getMulti(), expirationDate(transactionReportInstruction).get()));
			
			return Optional.ofNullable(emirReportableStrikePricePeriods)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
		
		@Override
		protected MapperS<Date> expirationDate(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(getExpirationDate.evaluate(transactionReportInstruction));
		}
		
		@Override
		protected MapperC<? extends PriceReportablePeriod> genericReportableStrikePriceSchedule(TransactionReportInstruction transactionReportInstruction) {
			return MapperC.<PriceReportablePeriod>of(getReportableStrikePricePeriod.evaluate(transactionReportInstruction));
		}
	}
}
