package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.datetime.Frequency;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.schedule.PaymentDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.AdjustPeriodMultiplier;
import drr.regulation.common.functions.FormatToMax3Number;
import drr.standards.iosco.cde.reports.CDEPaymentFrequencyPeriodRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(CDEPaymentFrequencyPeriodMultiplierAdjustedRule.CDEPaymentFrequencyPeriodMultiplierAdjustedRuleDefault.class)
public abstract class CDEPaymentFrequencyPeriodMultiplierAdjustedRule implements ReportFunction<InterestRatePayout, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected AdjustPeriodMultiplier adjustPeriodMultiplier;
	@Inject protected CDEPaymentFrequencyPeriodRule cDEPaymentFrequencyPeriodRule;
	@Inject protected FormatToMax3Number formatToMax3Number;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(InterestRatePayout input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(InterestRatePayout input);

	public static class CDEPaymentFrequencyPeriodMultiplierAdjustedRuleDefault extends CDEPaymentFrequencyPeriodMultiplierAdjustedRule {
		@Override
		protected BigDecimal doEvaluate(InterestRatePayout input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, InterestRatePayout input) {
			final MapperS<BigDecimal> thenArg = MapperS.of(input)
				.mapSingleToItem(interestRatePayout -> {
					final MapperS<Integer> _thenArg = MapperS.of(input).<PaymentDates>map("getPaymentDates", _interestRatePayout -> _interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<Integer>map("getPeriodMultiplier", frequency -> frequency.getPeriodMultiplier());
					final Integer integer = _thenArg.get();
					return MapperS.of(adjustPeriodMultiplier.evaluate(cDEPaymentFrequencyPeriodRule.evaluate(interestRatePayout.get()), (integer == null ? null : BigDecimal.valueOf(integer))));
				});
			output = MapperS.of(formatToMax3Number.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
