package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableDelivery;
import java.time.LocalTime;


@ImplementedBy(DeliveryIntervalStartTimeRule.DeliveryIntervalStartTimeRuleDefault.class)
public abstract class DeliveryIntervalStartTimeRule implements ReportFunction<ReportableDelivery, LocalTime> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public LocalTime evaluate(ReportableDelivery input) {
		LocalTime output = doEvaluate(input);
		
		return output;
	}

	protected abstract LocalTime doEvaluate(ReportableDelivery input);

	public static class DeliveryIntervalStartTimeRuleDefault extends DeliveryIntervalStartTimeRule {
		@Override
		protected LocalTime doEvaluate(ReportableDelivery input) {
			LocalTime output = null;
			return assignOutput(output, input);
		}
		
		protected LocalTime assignOutput(LocalTime output, ReportableDelivery input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> item.<LocalTime>map("getDeliveryStartTime", reportableDelivery -> reportableDelivery.getDeliveryStartTime())).get();
			
			return output;
		}
	}
}
