package drr.regulation.esma.emir.refit.trade.reports;

import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InflationRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsFRA;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import iso20022.auth030.esma.Frequency13Code__1;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FloatingRatePaymentFrequencyPeriodOfLeg1Rule.FloatingRatePaymentFrequencyPeriodOfLeg1RuleDefault.class)
public abstract class FloatingRatePaymentFrequencyPeriodOfLeg1Rule implements ReportFunction<TransactionReportInstruction, Frequency13Code__1> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPaymentFrequencyPeriodAdjustedRule cDEPaymentFrequencyPeriodAdjustedRule;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected IsFRA isFRA;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Frequency13Code__1 evaluate(TransactionReportInstruction input) {
		Frequency13Code__1 output = doEvaluate(input);
		
		return output;
	}

	protected abstract Frequency13Code__1 doEvaluate(TransactionReportInstruction input);

	public static class FloatingRatePaymentFrequencyPeriodOfLeg1RuleDefault extends FloatingRatePaymentFrequencyPeriodOfLeg1Rule {
		@Override
		protected Frequency13Code__1 doEvaluate(TransactionReportInstruction input) {
			Frequency13Code__1 output = null;
			return assignOutput(output, input);
		}
		
		protected Frequency13Code__1 assignOutput(Frequency13Code__1 output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<Product> thenArg2 = thenArg1
				.filterSingleNullSafe(item -> areEqual(MapperS.of(isFRA.evaluate(item.get())), MapperS.of(false), CardinalityOperator.All).get());
			final MapperS<Product> thenArg3 = thenArg2
				.mapSingleToItem(item -> MapperS.of(productOrUnderlierProduct.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg4 = thenArg3
				.mapSingleToItem(item -> MapperS.of(interestRateLeg1.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg5 = thenArg4
				.filterSingleNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).or(exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()))).get());
			output = thenArg5
				.mapSingleToItem(item -> MapperS.of(cDEPaymentFrequencyPeriodAdjustedRule.evaluate(item.get())).checkedMap("to-enum", Frequency13Code__1::fromDisplayName, IllegalArgumentException.class)).get();
			
			return output;
		}
	}
}
