package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetNameOfTheFloatingRateOfLeg1;
import drr.regulation.common.functions.IsAllowableAction;
import javax.inject.Inject;


@ImplementedBy(NameOfTheFloatingRateOfLeg1Rule.NameOfTheFloatingRateOfLeg1RuleDefault.class)
public abstract class NameOfTheFloatingRateOfLeg1Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetNameOfTheFloatingRateOfLeg1 getNameOfTheFloatingRateOfLeg1;
	@Inject protected IsAllowableAction isAllowableAction;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class NameOfTheFloatingRateOfLeg1RuleDefault extends NameOfTheFloatingRateOfLeg1Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(getNameOfTheFloatingRateOfLeg1.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
