package drr.regulation.esma.emir.refit.trade.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.esma.emir.refit.trade.PriceAndNotation;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class PriceAndNotationValidator implements Validator<PriceAndNotation> {

	private List<ComparisonResult> getComparisonResults(PriceAndNotation o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("priceMonetary", (BigDecimal) o.getPriceMonetary() != null ? 1 : 0, 0, 1), 
				checkCardinality("pricePercentage", (BigDecimal) o.getPricePercentage() != null ? 1 : 0, 0, 1), 
				checkCardinality("priceCurrency", (ISOCurrencyCodeEnum) o.getPriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("priceNotation", (PriceNotationEnum) o.getPriceNotation() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceAndNotation o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("PriceAndNotation", ValidationResult.ValidationType.CARDINALITY, "PriceAndNotation", path, "", res.getError());
				}
				return success("PriceAndNotation", ValidationResult.ValidationType.CARDINALITY, "PriceAndNotation", path, "");
			})
			.collect(toList());
	}

}
