package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import iso20022.auth030.esma.Frequency13Code__1;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.53.0
 */
@RosettaDataRule("ESMAEMIRTransactionReportEMIR_VR_2088_01")
@ImplementedBy(ESMAEMIRTransactionReportEMIR_VR_2088_01.Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2088_01 extends Validator<ESMAEMIRTransactionReport> {
	
	String NAME = "ESMAEMIRTransactionReportEMIR_VR_2088_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if [Frequency13Code__1 -> YEAR, Frequency13Code__1 -> MNTH, Frequency13Code__1 -> WEEK, Frequency13Code__1 -> DAIL, Frequency13Code__1 -> EXPI] any = floatingRatePaymentFrequencyPeriodOfLeg1 then floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 exists and floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 >= 0 else floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 is absent";
	
	class Default implements ESMAEMIRTransactionReportEMIR_VR_2088_01 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(eSMAEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(eSMAEMIRTransactionReport).<String>map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (areEqual(MapperC.<Frequency13Code__1>of(MapperS.of(Frequency13Code__1.YEAR), MapperS.of(Frequency13Code__1.MNTH), MapperS.of(Frequency13Code__1.WEEK), MapperS.of(Frequency13Code__1.DAIL), MapperS.of(Frequency13Code__1.EXPI)), MapperS.of(eSMAEMIRTransactionReport).<Frequency13Code__1>map("getFloatingRatePaymentFrequencyPeriodOfLeg1", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getFloatingRatePaymentFrequencyPeriodOfLeg1()), CardinalityOperator.Any).getOrDefault(false)) {
						return exists(MapperS.of(eSMAEMIRTransactionReport).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1())).and(greaterThanEquals(MapperS.of(eSMAEMIRTransactionReport).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1()), MapperS.of(0), CardinalityOperator.All));
					}
					return notExists(MapperS.of(eSMAEMIRTransactionReport).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ESMAEMIRTransactionReportEMIR_VR_2088_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
