package drr.regulation.esma.emir.refit.trade.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.regulation.esma.emir.refit.trade.PackageTransactionSpread;
import drr.standards.iso.PriceNotationEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.53.0
 */
@RosettaDataRule("ESMAEMIRTransactionReportEMIR_VR_2112_01")
@ImplementedBy(ESMAEMIRTransactionReportEMIR_VR_2112_01.Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2112_01 extends Validator<ESMAEMIRTransactionReport> {
	
	String NAME = "ESMAEMIRTransactionReportEMIR_VR_2112_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if packageTransactionSpread exists and packageTransactionSpread -> packageTransactionSpreadNotation = PriceNotationEnum -> Monetary then packageTransactionSpread -> packageTransactionSpreadCurrency exists else packageTransactionSpread -> packageTransactionSpreadCurrency is absent";
	
	class Default implements ESMAEMIRTransactionReportEMIR_VR_2112_01 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(eSMAEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(eSMAEMIRTransactionReport).<String>map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (exists(MapperS.of(eSMAEMIRTransactionReport).<PackageTransactionSpread>map("getPackageTransactionSpread", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getPackageTransactionSpread())).and(areEqual(MapperS.of(eSMAEMIRTransactionReport).<PackageTransactionSpread>map("getPackageTransactionSpread", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getPackageTransactionSpread()).<PriceNotationEnum>map("getPackageTransactionSpreadNotation", packageTransactionSpread -> packageTransactionSpread.getPackageTransactionSpreadNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All)).getOrDefault(false)) {
						return exists(MapperS.of(eSMAEMIRTransactionReport).<PackageTransactionSpread>map("getPackageTransactionSpread", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getPackageTransactionSpread()).<ISOCurrencyCodeEnum>map("getPackageTransactionSpreadCurrency", packageTransactionSpread -> packageTransactionSpread.getPackageTransactionSpreadCurrency()));
					}
					return notExists(MapperS.of(eSMAEMIRTransactionReport).<PackageTransactionSpread>map("getPackageTransactionSpread", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getPackageTransactionSpread()).<ISOCurrencyCodeEnum>map("getPackageTransactionSpreadCurrency", packageTransactionSpread -> packageTransactionSpread.getPackageTransactionSpreadCurrency()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ESMAEMIRTransactionReportEMIR_VR_2112_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
