package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.enrichment.eic.functions.IsAcceptedEicCode;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.DeliveryReport;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.53.0
 */
@RosettaDataRule("ESMAEMIRTransactionReportEMIR_VR_2125_01")
@ImplementedBy(ESMAEMIRTransactionReportEMIR_VR_2125_01.Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2125_01 extends Validator<ESMAEMIRTransactionReport> {
	
	String NAME = "ESMAEMIRTransactionReportEMIR_VR_2125_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) and deliveryReport exists then (deliveryReport extract dr [ if IsAcceptedEicCode(deliveryPoint) or IsAcceptedEicCode(interconnectionPoint) then dr -> deliveryEndDate exists else dr -> deliveryEndDate is absent ] then all = True)";
	
	class Default implements ESMAEMIRTransactionReportEMIR_VR_2125_01 {
	
		@Inject protected IsAcceptedEicCode isAcceptedEicCode;
		
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(eSMAEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			try {
				if (ComparisonResult.of(MapperS.of(isVRAllowedForActionType.evaluate(MapperS.of(eSMAEMIRTransactionReport).<String>map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get()))).and(exists(MapperS.of(eSMAEMIRTransactionReport).<DeliveryReport>mapC("getDeliveryReport", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getDeliveryReport()))).getOrDefault(false)) {
					final MapperC<Boolean> thenArg = MapperS.of(eSMAEMIRTransactionReport).<DeliveryReport>mapC("getDeliveryReport", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getDeliveryReport())
						.mapItem(dr -> {
							if (ComparisonResult.of(MapperS.of(isAcceptedEicCode.evaluate(MapperS.of(eSMAEMIRTransactionReport).<String>mapC("getDeliveryPoint", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getDeliveryPoint()).getMulti()))).or(ComparisonResult.of(MapperS.of(isAcceptedEicCode.evaluate(MapperS.of(eSMAEMIRTransactionReport).<String>map("getInterconnectionPoint", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getInterconnectionPoint()).getMulti())))).getOrDefault(false)) {
								return exists(dr.<Date>map("getDeliveryEndDate", deliveryReport -> deliveryReport.getDeliveryEndDate())).asMapper();
							}
							return notExists(dr.<Date>map("getDeliveryEndDate", deliveryReport -> deliveryReport.getDeliveryEndDate())).asMapper();
						});
					return ComparisonResult.of(areEqual(thenArg, MapperS.of(true), CardinalityOperator.All).asMapper());
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ESMAEMIRTransactionReportEMIR_VR_2125_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
