package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.esma.emir.refit.trade.SpreadOfLeg2;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.53.0
 */
@RosettaDataRule("SpreadOfLeg2MonetaryOrPercentageOrBasis")
@ImplementedBy(SpreadOfLeg2MonetaryOrPercentageOrBasis.Default.class)
public interface SpreadOfLeg2MonetaryOrPercentageOrBasis extends Validator<SpreadOfLeg2> {
	
	String NAME = "SpreadOfLeg2MonetaryOrPercentageOrBasis";
	String DEFINITION = "optional choice spreadOfLeg2Monetary, spreadOfLeg2Percentage, spreadOfLeg2Basis";
	
	class Default implements SpreadOfLeg2MonetaryOrPercentageOrBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadOfLeg2 spreadOfLeg2) {
			ComparisonResult result = executeDataRule(spreadOfLeg2);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SpreadOfLeg2", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "SpreadOfLeg2", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(SpreadOfLeg2 spreadOfLeg2) {
			try {
				return choice(MapperS.of(spreadOfLeg2), Arrays.asList("spreadOfLeg2Monetary", "spreadOfLeg2Percentage", "spreadOfLeg2Basis"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements SpreadOfLeg2MonetaryOrPercentageOrBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadOfLeg2 spreadOfLeg2) {
			return Collections.emptyList();
		}
	}
}
