package drr.regulation.fca.ukemir.refit.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.enrichment.common.EnrichmentData;
import drr.regulation.fca.ukemir.refit.trade.meta.FCAUKEMIRNonReportableMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.53.0
 */
@RosettaDataType(value="FCAUKEMIRNonReportable", builder=FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilderImpl.class, version="5.53.0")
@RuneDataType(value="FCAUKEMIRNonReportable", model="drr", builder=FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilderImpl.class, version="5.53.0")
public interface FCAUKEMIRNonReportable extends RosettaModelObject {

	FCAUKEMIRNonReportableMeta metaData = new FCAUKEMIRNonReportableMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Populated by pre-enrichment process
	 */
	EnrichmentData getEnrichment();
	String getRelationshipRecord();

	/*********************** Build Methods  ***********************/
	FCAUKEMIRNonReportable build();
	
	FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder toBuilder();
	
	static FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder builder() {
		return new FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends FCAUKEMIRNonReportable> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends FCAUKEMIRNonReportable> getType() {
		return FCAUKEMIRNonReportable.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("enrichment"), processor, EnrichmentData.class, getEnrichment());
		processor.processBasic(path.newSubPath("relationshipRecord"), String.class, getRelationshipRecord(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface FCAUKEMIRNonReportableBuilder extends FCAUKEMIRNonReportable, RosettaModelObjectBuilder {
		EnrichmentData.EnrichmentDataBuilder getOrCreateEnrichment();
		@Override
		EnrichmentData.EnrichmentDataBuilder getEnrichment();
		FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder setEnrichment(EnrichmentData enrichment);
		FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder setRelationshipRecord(String relationshipRecord);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("enrichment"), processor, EnrichmentData.EnrichmentDataBuilder.class, getEnrichment());
			processor.processBasic(path.newSubPath("relationshipRecord"), String.class, getRelationshipRecord(), this);
		}
		

		FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder prune();
	}

	/*********************** Immutable Implementation of FCAUKEMIRNonReportable  ***********************/
	class FCAUKEMIRNonReportableImpl implements FCAUKEMIRNonReportable {
		private final EnrichmentData enrichment;
		private final String relationshipRecord;
		
		protected FCAUKEMIRNonReportableImpl(FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder builder) {
			this.enrichment = ofNullable(builder.getEnrichment()).map(f->f.build()).orElse(null);
			this.relationshipRecord = builder.getRelationshipRecord();
		}
		
		@Override
		@RosettaAttribute("enrichment")
		@RuneAttribute("enrichment")
		public EnrichmentData getEnrichment() {
			return enrichment;
		}
		
		@Override
		@RosettaAttribute("relationshipRecord")
		@RuneAttribute("relationshipRecord")
		public String getRelationshipRecord() {
			return relationshipRecord;
		}
		
		@Override
		public FCAUKEMIRNonReportable build() {
			return this;
		}
		
		@Override
		public FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder toBuilder() {
			FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder builder) {
			ofNullable(getEnrichment()).ifPresent(builder::setEnrichment);
			ofNullable(getRelationshipRecord()).ifPresent(builder::setRelationshipRecord);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FCAUKEMIRNonReportable _that = getType().cast(o);
		
			if (!Objects.equals(enrichment, _that.getEnrichment())) return false;
			if (!Objects.equals(relationshipRecord, _that.getRelationshipRecord())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (enrichment != null ? enrichment.hashCode() : 0);
			_result = 31 * _result + (relationshipRecord != null ? relationshipRecord.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FCAUKEMIRNonReportable {" +
				"enrichment=" + this.enrichment + ", " +
				"relationshipRecord=" + this.relationshipRecord +
			'}';
		}
	}

	/*********************** Builder Implementation of FCAUKEMIRNonReportable  ***********************/
	class FCAUKEMIRNonReportableBuilderImpl implements FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder {
	
		protected EnrichmentData.EnrichmentDataBuilder enrichment;
		protected String relationshipRecord;
		
		@Override
		@RosettaAttribute("enrichment")
		@RuneAttribute("enrichment")
		public EnrichmentData.EnrichmentDataBuilder getEnrichment() {
			return enrichment;
		}
		
		@Override
		public EnrichmentData.EnrichmentDataBuilder getOrCreateEnrichment() {
			EnrichmentData.EnrichmentDataBuilder result;
			if (enrichment!=null) {
				result = enrichment;
			}
			else {
				result = enrichment = EnrichmentData.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("relationshipRecord")
		@RuneAttribute("relationshipRecord")
		public String getRelationshipRecord() {
			return relationshipRecord;
		}
		
		@RosettaAttribute("enrichment")
		@RuneAttribute("enrichment")
		@Override
		public FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder setEnrichment(EnrichmentData _enrichment) {
			this.enrichment = _enrichment == null ? null : _enrichment.toBuilder();
			return this;
		}
		
		@RosettaAttribute("relationshipRecord")
		@RuneAttribute("relationshipRecord")
		@Override
		public FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder setRelationshipRecord(String _relationshipRecord) {
			this.relationshipRecord = _relationshipRecord == null ? null : _relationshipRecord;
			return this;
		}
		
		@Override
		public FCAUKEMIRNonReportable build() {
			return new FCAUKEMIRNonReportable.FCAUKEMIRNonReportableImpl(this);
		}
		
		@Override
		public FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder prune() {
			if (enrichment!=null && !enrichment.prune().hasData()) enrichment = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getEnrichment()!=null && getEnrichment().hasData()) return true;
			if (getRelationshipRecord()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder o = (FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder) other;
			
			merger.mergeRosetta(getEnrichment(), o.getEnrichment(), this::setEnrichment);
			
			merger.mergeBasic(getRelationshipRecord(), o.getRelationshipRecord(), this::setRelationshipRecord);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FCAUKEMIRNonReportable _that = getType().cast(o);
		
			if (!Objects.equals(enrichment, _that.getEnrichment())) return false;
			if (!Objects.equals(relationshipRecord, _that.getRelationshipRecord())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (enrichment != null ? enrichment.hashCode() : 0);
			_result = 31 * _result + (relationshipRecord != null ? relationshipRecord.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FCAUKEMIRNonReportableBuilder {" +
				"enrichment=" + this.enrichment + ", " +
				"relationshipRecord=" + this.relationshipRecord +
			'}';
		}
	}
}
