package drr.regulation.fca.ukemir.refit.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.fca.ukemir.refit.trade.meta.StrikePriceScheduleReportMeta;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.53.0
 */
@RosettaDataType(value="StrikePriceScheduleReport", builder=StrikePriceScheduleReport.StrikePriceScheduleReportBuilderImpl.class, version="5.53.0")
@RuneDataType(value="StrikePriceScheduleReport", model="drr", builder=StrikePriceScheduleReport.StrikePriceScheduleReportBuilderImpl.class, version="5.53.0")
public interface StrikePriceScheduleReport extends RosettaModelObject {

	StrikePriceScheduleReportMeta metaData = new StrikePriceScheduleReportMeta();

	/*********************** Getter Methods  ***********************/
	Date getEffectiveDateStrikePrice();
	Date getEndDateStrikePrice();
	BigDecimal getStrikePriceInEffectOnAssociatedEffectiveDateMonetary();
	BigDecimal getStrikePriceInEffectOnAssociatedEffectiveDatePercentage();
	PriceNotationEnum getStrikePriceNotationInEffectOnAssociatedEffectiveDate();

	/*********************** Build Methods  ***********************/
	StrikePriceScheduleReport build();
	
	StrikePriceScheduleReport.StrikePriceScheduleReportBuilder toBuilder();
	
	static StrikePriceScheduleReport.StrikePriceScheduleReportBuilder builder() {
		return new StrikePriceScheduleReport.StrikePriceScheduleReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends StrikePriceScheduleReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends StrikePriceScheduleReport> getType() {
		return StrikePriceScheduleReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("effectiveDateStrikePrice"), Date.class, getEffectiveDateStrikePrice(), this);
		processor.processBasic(path.newSubPath("endDateStrikePrice"), Date.class, getEndDateStrikePrice(), this);
		processor.processBasic(path.newSubPath("strikePriceInEffectOnAssociatedEffectiveDateMonetary"), BigDecimal.class, getStrikePriceInEffectOnAssociatedEffectiveDateMonetary(), this);
		processor.processBasic(path.newSubPath("strikePriceInEffectOnAssociatedEffectiveDatePercentage"), BigDecimal.class, getStrikePriceInEffectOnAssociatedEffectiveDatePercentage(), this);
		processor.processBasic(path.newSubPath("strikePriceNotationInEffectOnAssociatedEffectiveDate"), PriceNotationEnum.class, getStrikePriceNotationInEffectOnAssociatedEffectiveDate(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface StrikePriceScheduleReportBuilder extends StrikePriceScheduleReport, RosettaModelObjectBuilder {
		StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setEffectiveDateStrikePrice(Date effectiveDateStrikePrice);
		StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setEndDateStrikePrice(Date endDateStrikePrice);
		StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setStrikePriceInEffectOnAssociatedEffectiveDateMonetary(BigDecimal strikePriceInEffectOnAssociatedEffectiveDateMonetary);
		StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setStrikePriceInEffectOnAssociatedEffectiveDatePercentage(BigDecimal strikePriceInEffectOnAssociatedEffectiveDatePercentage);
		StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setStrikePriceNotationInEffectOnAssociatedEffectiveDate(PriceNotationEnum strikePriceNotationInEffectOnAssociatedEffectiveDate);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("effectiveDateStrikePrice"), Date.class, getEffectiveDateStrikePrice(), this);
			processor.processBasic(path.newSubPath("endDateStrikePrice"), Date.class, getEndDateStrikePrice(), this);
			processor.processBasic(path.newSubPath("strikePriceInEffectOnAssociatedEffectiveDateMonetary"), BigDecimal.class, getStrikePriceInEffectOnAssociatedEffectiveDateMonetary(), this);
			processor.processBasic(path.newSubPath("strikePriceInEffectOnAssociatedEffectiveDatePercentage"), BigDecimal.class, getStrikePriceInEffectOnAssociatedEffectiveDatePercentage(), this);
			processor.processBasic(path.newSubPath("strikePriceNotationInEffectOnAssociatedEffectiveDate"), PriceNotationEnum.class, getStrikePriceNotationInEffectOnAssociatedEffectiveDate(), this);
		}
		

		StrikePriceScheduleReport.StrikePriceScheduleReportBuilder prune();
	}

	/*********************** Immutable Implementation of StrikePriceScheduleReport  ***********************/
	class StrikePriceScheduleReportImpl implements StrikePriceScheduleReport {
		private final Date effectiveDateStrikePrice;
		private final Date endDateStrikePrice;
		private final BigDecimal strikePriceInEffectOnAssociatedEffectiveDateMonetary;
		private final BigDecimal strikePriceInEffectOnAssociatedEffectiveDatePercentage;
		private final PriceNotationEnum strikePriceNotationInEffectOnAssociatedEffectiveDate;
		
		protected StrikePriceScheduleReportImpl(StrikePriceScheduleReport.StrikePriceScheduleReportBuilder builder) {
			this.effectiveDateStrikePrice = builder.getEffectiveDateStrikePrice();
			this.endDateStrikePrice = builder.getEndDateStrikePrice();
			this.strikePriceInEffectOnAssociatedEffectiveDateMonetary = builder.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary();
			this.strikePriceInEffectOnAssociatedEffectiveDatePercentage = builder.getStrikePriceInEffectOnAssociatedEffectiveDatePercentage();
			this.strikePriceNotationInEffectOnAssociatedEffectiveDate = builder.getStrikePriceNotationInEffectOnAssociatedEffectiveDate();
		}
		
		@Override
		@RosettaAttribute("effectiveDateStrikePrice")
		@RuneAttribute("effectiveDateStrikePrice")
		public Date getEffectiveDateStrikePrice() {
			return effectiveDateStrikePrice;
		}
		
		@Override
		@RosettaAttribute("endDateStrikePrice")
		@RuneAttribute("endDateStrikePrice")
		public Date getEndDateStrikePrice() {
			return endDateStrikePrice;
		}
		
		@Override
		@RosettaAttribute("strikePriceInEffectOnAssociatedEffectiveDateMonetary")
		@RuneAttribute("strikePriceInEffectOnAssociatedEffectiveDateMonetary")
		public BigDecimal getStrikePriceInEffectOnAssociatedEffectiveDateMonetary() {
			return strikePriceInEffectOnAssociatedEffectiveDateMonetary;
		}
		
		@Override
		@RosettaAttribute("strikePriceInEffectOnAssociatedEffectiveDatePercentage")
		@RuneAttribute("strikePriceInEffectOnAssociatedEffectiveDatePercentage")
		public BigDecimal getStrikePriceInEffectOnAssociatedEffectiveDatePercentage() {
			return strikePriceInEffectOnAssociatedEffectiveDatePercentage;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotationInEffectOnAssociatedEffectiveDate")
		@RuneAttribute("strikePriceNotationInEffectOnAssociatedEffectiveDate")
		public PriceNotationEnum getStrikePriceNotationInEffectOnAssociatedEffectiveDate() {
			return strikePriceNotationInEffectOnAssociatedEffectiveDate;
		}
		
		@Override
		public StrikePriceScheduleReport build() {
			return this;
		}
		
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder toBuilder() {
			StrikePriceScheduleReport.StrikePriceScheduleReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(StrikePriceScheduleReport.StrikePriceScheduleReportBuilder builder) {
			ofNullable(getEffectiveDateStrikePrice()).ifPresent(builder::setEffectiveDateStrikePrice);
			ofNullable(getEndDateStrikePrice()).ifPresent(builder::setEndDateStrikePrice);
			ofNullable(getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()).ifPresent(builder::setStrikePriceInEffectOnAssociatedEffectiveDateMonetary);
			ofNullable(getStrikePriceInEffectOnAssociatedEffectiveDatePercentage()).ifPresent(builder::setStrikePriceInEffectOnAssociatedEffectiveDatePercentage);
			ofNullable(getStrikePriceNotationInEffectOnAssociatedEffectiveDate()).ifPresent(builder::setStrikePriceNotationInEffectOnAssociatedEffectiveDate);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			StrikePriceScheduleReport _that = getType().cast(o);
		
			if (!Objects.equals(effectiveDateStrikePrice, _that.getEffectiveDateStrikePrice())) return false;
			if (!Objects.equals(endDateStrikePrice, _that.getEndDateStrikePrice())) return false;
			if (!Objects.equals(strikePriceInEffectOnAssociatedEffectiveDateMonetary, _that.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary())) return false;
			if (!Objects.equals(strikePriceInEffectOnAssociatedEffectiveDatePercentage, _that.getStrikePriceInEffectOnAssociatedEffectiveDatePercentage())) return false;
			if (!Objects.equals(strikePriceNotationInEffectOnAssociatedEffectiveDate, _that.getStrikePriceNotationInEffectOnAssociatedEffectiveDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (effectiveDateStrikePrice != null ? effectiveDateStrikePrice.hashCode() : 0);
			_result = 31 * _result + (endDateStrikePrice != null ? endDateStrikePrice.hashCode() : 0);
			_result = 31 * _result + (strikePriceInEffectOnAssociatedEffectiveDateMonetary != null ? strikePriceInEffectOnAssociatedEffectiveDateMonetary.hashCode() : 0);
			_result = 31 * _result + (strikePriceInEffectOnAssociatedEffectiveDatePercentage != null ? strikePriceInEffectOnAssociatedEffectiveDatePercentage.hashCode() : 0);
			_result = 31 * _result + (strikePriceNotationInEffectOnAssociatedEffectiveDate != null ? strikePriceNotationInEffectOnAssociatedEffectiveDate.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "StrikePriceScheduleReport {" +
				"effectiveDateStrikePrice=" + this.effectiveDateStrikePrice + ", " +
				"endDateStrikePrice=" + this.endDateStrikePrice + ", " +
				"strikePriceInEffectOnAssociatedEffectiveDateMonetary=" + this.strikePriceInEffectOnAssociatedEffectiveDateMonetary + ", " +
				"strikePriceInEffectOnAssociatedEffectiveDatePercentage=" + this.strikePriceInEffectOnAssociatedEffectiveDatePercentage + ", " +
				"strikePriceNotationInEffectOnAssociatedEffectiveDate=" + this.strikePriceNotationInEffectOnAssociatedEffectiveDate +
			'}';
		}
	}

	/*********************** Builder Implementation of StrikePriceScheduleReport  ***********************/
	class StrikePriceScheduleReportBuilderImpl implements StrikePriceScheduleReport.StrikePriceScheduleReportBuilder {
	
		protected Date effectiveDateStrikePrice;
		protected Date endDateStrikePrice;
		protected BigDecimal strikePriceInEffectOnAssociatedEffectiveDateMonetary;
		protected BigDecimal strikePriceInEffectOnAssociatedEffectiveDatePercentage;
		protected PriceNotationEnum strikePriceNotationInEffectOnAssociatedEffectiveDate;
		
		@Override
		@RosettaAttribute("effectiveDateStrikePrice")
		@RuneAttribute("effectiveDateStrikePrice")
		public Date getEffectiveDateStrikePrice() {
			return effectiveDateStrikePrice;
		}
		
		@Override
		@RosettaAttribute("endDateStrikePrice")
		@RuneAttribute("endDateStrikePrice")
		public Date getEndDateStrikePrice() {
			return endDateStrikePrice;
		}
		
		@Override
		@RosettaAttribute("strikePriceInEffectOnAssociatedEffectiveDateMonetary")
		@RuneAttribute("strikePriceInEffectOnAssociatedEffectiveDateMonetary")
		public BigDecimal getStrikePriceInEffectOnAssociatedEffectiveDateMonetary() {
			return strikePriceInEffectOnAssociatedEffectiveDateMonetary;
		}
		
		@Override
		@RosettaAttribute("strikePriceInEffectOnAssociatedEffectiveDatePercentage")
		@RuneAttribute("strikePriceInEffectOnAssociatedEffectiveDatePercentage")
		public BigDecimal getStrikePriceInEffectOnAssociatedEffectiveDatePercentage() {
			return strikePriceInEffectOnAssociatedEffectiveDatePercentage;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotationInEffectOnAssociatedEffectiveDate")
		@RuneAttribute("strikePriceNotationInEffectOnAssociatedEffectiveDate")
		public PriceNotationEnum getStrikePriceNotationInEffectOnAssociatedEffectiveDate() {
			return strikePriceNotationInEffectOnAssociatedEffectiveDate;
		}
		
		@RosettaAttribute("effectiveDateStrikePrice")
		@RuneAttribute("effectiveDateStrikePrice")
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setEffectiveDateStrikePrice(Date _effectiveDateStrikePrice) {
			this.effectiveDateStrikePrice = _effectiveDateStrikePrice == null ? null : _effectiveDateStrikePrice;
			return this;
		}
		
		@RosettaAttribute("endDateStrikePrice")
		@RuneAttribute("endDateStrikePrice")
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setEndDateStrikePrice(Date _endDateStrikePrice) {
			this.endDateStrikePrice = _endDateStrikePrice == null ? null : _endDateStrikePrice;
			return this;
		}
		
		@RosettaAttribute("strikePriceInEffectOnAssociatedEffectiveDateMonetary")
		@RuneAttribute("strikePriceInEffectOnAssociatedEffectiveDateMonetary")
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setStrikePriceInEffectOnAssociatedEffectiveDateMonetary(BigDecimal _strikePriceInEffectOnAssociatedEffectiveDateMonetary) {
			this.strikePriceInEffectOnAssociatedEffectiveDateMonetary = _strikePriceInEffectOnAssociatedEffectiveDateMonetary == null ? null : _strikePriceInEffectOnAssociatedEffectiveDateMonetary;
			return this;
		}
		
		@RosettaAttribute("strikePriceInEffectOnAssociatedEffectiveDatePercentage")
		@RuneAttribute("strikePriceInEffectOnAssociatedEffectiveDatePercentage")
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setStrikePriceInEffectOnAssociatedEffectiveDatePercentage(BigDecimal _strikePriceInEffectOnAssociatedEffectiveDatePercentage) {
			this.strikePriceInEffectOnAssociatedEffectiveDatePercentage = _strikePriceInEffectOnAssociatedEffectiveDatePercentage == null ? null : _strikePriceInEffectOnAssociatedEffectiveDatePercentage;
			return this;
		}
		
		@RosettaAttribute("strikePriceNotationInEffectOnAssociatedEffectiveDate")
		@RuneAttribute("strikePriceNotationInEffectOnAssociatedEffectiveDate")
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setStrikePriceNotationInEffectOnAssociatedEffectiveDate(PriceNotationEnum _strikePriceNotationInEffectOnAssociatedEffectiveDate) {
			this.strikePriceNotationInEffectOnAssociatedEffectiveDate = _strikePriceNotationInEffectOnAssociatedEffectiveDate == null ? null : _strikePriceNotationInEffectOnAssociatedEffectiveDate;
			return this;
		}
		
		@Override
		public StrikePriceScheduleReport build() {
			return new StrikePriceScheduleReport.StrikePriceScheduleReportImpl(this);
		}
		
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getEffectiveDateStrikePrice()!=null) return true;
			if (getEndDateStrikePrice()!=null) return true;
			if (getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()!=null) return true;
			if (getStrikePriceInEffectOnAssociatedEffectiveDatePercentage()!=null) return true;
			if (getStrikePriceNotationInEffectOnAssociatedEffectiveDate()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			StrikePriceScheduleReport.StrikePriceScheduleReportBuilder o = (StrikePriceScheduleReport.StrikePriceScheduleReportBuilder) other;
			
			
			merger.mergeBasic(getEffectiveDateStrikePrice(), o.getEffectiveDateStrikePrice(), this::setEffectiveDateStrikePrice);
			merger.mergeBasic(getEndDateStrikePrice(), o.getEndDateStrikePrice(), this::setEndDateStrikePrice);
			merger.mergeBasic(getStrikePriceInEffectOnAssociatedEffectiveDateMonetary(), o.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary(), this::setStrikePriceInEffectOnAssociatedEffectiveDateMonetary);
			merger.mergeBasic(getStrikePriceInEffectOnAssociatedEffectiveDatePercentage(), o.getStrikePriceInEffectOnAssociatedEffectiveDatePercentage(), this::setStrikePriceInEffectOnAssociatedEffectiveDatePercentage);
			merger.mergeBasic(getStrikePriceNotationInEffectOnAssociatedEffectiveDate(), o.getStrikePriceNotationInEffectOnAssociatedEffectiveDate(), this::setStrikePriceNotationInEffectOnAssociatedEffectiveDate);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			StrikePriceScheduleReport _that = getType().cast(o);
		
			if (!Objects.equals(effectiveDateStrikePrice, _that.getEffectiveDateStrikePrice())) return false;
			if (!Objects.equals(endDateStrikePrice, _that.getEndDateStrikePrice())) return false;
			if (!Objects.equals(strikePriceInEffectOnAssociatedEffectiveDateMonetary, _that.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary())) return false;
			if (!Objects.equals(strikePriceInEffectOnAssociatedEffectiveDatePercentage, _that.getStrikePriceInEffectOnAssociatedEffectiveDatePercentage())) return false;
			if (!Objects.equals(strikePriceNotationInEffectOnAssociatedEffectiveDate, _that.getStrikePriceNotationInEffectOnAssociatedEffectiveDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (effectiveDateStrikePrice != null ? effectiveDateStrikePrice.hashCode() : 0);
			_result = 31 * _result + (endDateStrikePrice != null ? endDateStrikePrice.hashCode() : 0);
			_result = 31 * _result + (strikePriceInEffectOnAssociatedEffectiveDateMonetary != null ? strikePriceInEffectOnAssociatedEffectiveDateMonetary.hashCode() : 0);
			_result = 31 * _result + (strikePriceInEffectOnAssociatedEffectiveDatePercentage != null ? strikePriceInEffectOnAssociatedEffectiveDatePercentage.hashCode() : 0);
			_result = 31 * _result + (strikePriceNotationInEffectOnAssociatedEffectiveDate != null ? strikePriceNotationInEffectOnAssociatedEffectiveDate.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "StrikePriceScheduleReportBuilder {" +
				"effectiveDateStrikePrice=" + this.effectiveDateStrikePrice + ", " +
				"endDateStrikePrice=" + this.endDateStrikePrice + ", " +
				"strikePriceInEffectOnAssociatedEffectiveDateMonetary=" + this.strikePriceInEffectOnAssociatedEffectiveDateMonetary + ", " +
				"strikePriceInEffectOnAssociatedEffectiveDatePercentage=" + this.strikePriceInEffectOnAssociatedEffectiveDatePercentage + ", " +
				"strikePriceNotationInEffectOnAssociatedEffectiveDate=" + this.strikePriceNotationInEffectOnAssociatedEffectiveDate +
			'}';
		}
	}
}
