package drr.regulation.fca.ukemir.refit.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.fca.ukemir.refit.trade.SpreadOfLeg2;
import drr.regulation.fca.ukemir.refit.trade.validation.SpreadOfLeg2TypeFormatValidator;
import drr.regulation.fca.ukemir.refit.trade.validation.SpreadOfLeg2Validator;
import drr.regulation.fca.ukemir.refit.trade.validation.datarule.SpreadOfLeg2MonetaryOrPercentageOrBasis;
import drr.regulation.fca.ukemir.refit.trade.validation.exists.SpreadOfLeg2OnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.53.0
 */
@RosettaMeta(model=SpreadOfLeg2.class)
public class SpreadOfLeg2Meta implements RosettaMetaData<SpreadOfLeg2> {

	@Override
	public List<Validator<? super SpreadOfLeg2>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<SpreadOfLeg2>create(SpreadOfLeg2MonetaryOrPercentageOrBasis.class)
		);
	}
	
	@Override
	public List<Function<? super SpreadOfLeg2, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super SpreadOfLeg2> validator(ValidatorFactory factory) {
		return factory.<SpreadOfLeg2>create(SpreadOfLeg2Validator.class);
	}

	@Override
	public Validator<? super SpreadOfLeg2> typeFormatValidator(ValidatorFactory factory) {
		return factory.<SpreadOfLeg2>create(SpreadOfLeg2TypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super SpreadOfLeg2> validator() {
		return new SpreadOfLeg2Validator();
	}

	@Deprecated
	@Override
	public Validator<? super SpreadOfLeg2> typeFormatValidator() {
		return new SpreadOfLeg2TypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super SpreadOfLeg2, Set<String>> onlyExistsValidator() {
		return new SpreadOfLeg2OnlyExistsValidator();
	}
}
