package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableDelivery;
import iso20022.auth030.fca.DurationType1Code;


@ImplementedBy(DurationRule.DurationRuleDefault.class)
public abstract class DurationRule implements ReportFunction<ReportableDelivery, DurationType1Code> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public DurationType1Code evaluate(ReportableDelivery input) {
		DurationType1Code output = doEvaluate(input);
		
		return output;
	}

	protected abstract DurationType1Code doEvaluate(ReportableDelivery input);

	public static class DurationRuleDefault extends DurationRule {
		@Override
		protected DurationType1Code doEvaluate(ReportableDelivery input) {
			DurationType1Code output = null;
			return assignOutput(output, input);
		}
		
		protected DurationType1Code assignOutput(DurationType1Code output, ReportableDelivery input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> item.<iso20022.auth030.esma.DurationType1Code>map("getDuration", reportableDelivery -> reportableDelivery.getDuration()).checkedMap("to-enum", e -> DurationType1Code.valueOf(e.name()), IllegalArgumentException.class)).get();
			
			return output;
		}
	}
}
