package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.IndexReferenceInformation;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.CommodityPayout;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.CreditIndexReferenceInformation;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.GeneralTerms;
import cdm.product.asset.InflationRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.qualification.functions.Qualify_BaseProduct_IRSwap;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.IsFRA;
import drr.regulation.common.functions.IsIRSwaption;
import drr.regulation.common.functions.IsProductETD;
import drr.regulation.common.functions.IsSingleCommodityPayoutProduct;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(NameOfTheUnderlyingIndexRule.NameOfTheUnderlyingIndexRuleDefault.class)
public abstract class NameOfTheUnderlyingIndexRule implements ReportFunction<TransactionReportInstruction, List<String>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsFRA isFRA;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected IsProductETD isProductETD;
	@Inject protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_BaseProduct_IRSwap qualify_BaseProduct_IRSwap;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<String> evaluate(TransactionReportInstruction input) {
		List<String> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<String> doEvaluate(TransactionReportInstruction input);

	public static class NameOfTheUnderlyingIndexRuleDefault extends NameOfTheUnderlyingIndexRule {
		@Override
		protected List<String> doEvaluate(TransactionReportInstruction input) {
			List<String> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<String> assignOutput(List<String> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					if (ComparisonResult.of(MapperS.of(isCreditSwaption.evaluate(productForEvent.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isIRSwaption.evaluate(productForEvent.evaluate(item.get()))))).getOrDefault(false)) {
						return MapperS.of(underlierForProduct.evaluate(productForEvent.evaluate(item.get())));
					}
					return MapperS.of(productForEvent.evaluate(item.get()));
				});
			output = thenArg1
				.mapSingleToList(item -> {
					if (exists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation())).getOrDefault(false)) {
						return MapperC.of(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).<FieldWithMetaString>map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName()).<String>map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()));
					}
					if (exists(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation())).getOrDefault(false)) {
						return MapperC.of(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).<FieldWithMetaString>map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName()).<String>map("Type coercion", fieldWithMetaString1 -> fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()));
					}
					if (exists(MapperS.of(underlierForProduct.evaluate(item.get())).<Index>map("getIndex", product -> product.getIndex())).and(areEqual(MapperS.of(underlierForProduct.evaluate(item.get())).<Index>map("getIndex", product -> product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.NAME), CardinalityOperator.Any)).getOrDefault(false)) {
						final MapperC<ReferenceWithMetaProductIdentifier> _thenArg0 = MapperS.of(underlierForProduct.evaluate(item.get())).<Index>map("getIndex", product -> product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier());
						final MapperC<ReferenceWithMetaProductIdentifier> _thenArg1 = _thenArg0
							.filterItemNullSafe(_item -> areEqual(_item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.NAME), CardinalityOperator.All).get());
						return _thenArg1
							.mapItem(_item -> _item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue());
					}
					if (exists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Index>map("getIndex", product -> product.getIndex())).getOrDefault(false)) {
						final MapperC<ReferenceWithMetaProductIdentifier> thenArg2 = MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Index>map("getIndex", product -> product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier());
						final MapperC<ReferenceWithMetaProductIdentifier> thenArg3 = thenArg2
							.filterItemNullSafe(_item -> areEqual(_item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.NAME), CardinalityOperator.All).get());
						return thenArg3
							.mapItem(_item -> _item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue());
					}
					if (ComparisonResult.of(MapperS.of(isProductETD.evaluate(item.get()))).and(exists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Index>map("getIndex", product -> product.getIndex()))).and(areEqual(MapperS.of(isSingleCommodityPayoutProduct.evaluate(item.get())), MapperS.of(false), CardinalityOperator.All)).getOrDefault(false)) {
						final MapperC<ReferenceWithMetaProductIdentifier> thenArg4 = MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Index>map("getIndex", product -> product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier());
						final MapperC<ReferenceWithMetaProductIdentifier> thenArg5 = thenArg4
							.filterItemNullSafe(_item -> areEqual(_item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.NAME), CardinalityOperator.All).get());
						return thenArg5
							.mapItem(_item -> _item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue());
					}
					final Boolean boolean0 = isFRA.evaluate(item.get());
					if ((boolean0 == null ? false : boolean0)) {
						return MapperC.of(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation()).<FieldWithMetaString>map("getIndexName", indexReferenceInformation -> indexReferenceInformation.getIndexName())
							.first().<String>map("Type coercion", fieldWithMetaString2 -> fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue()));
					}
					final Boolean boolean1 = qualify_BaseProduct_IRSwap.evaluate(economicTermsForProduct.evaluate(item.get()));
					if ((boolean1 == null ? false : boolean1)) {
						final FieldWithMetaString fieldWithMetaString3 = MapperC.<FieldWithMetaString>of(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation()).<FieldWithMetaString>map("getIndexName", indexReferenceInformation -> indexReferenceInformation.getIndexName())
							.first(), MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", inflationRateSpecification -> inflationRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation()).<FieldWithMetaString>map("getIndexName", indexReferenceInformation -> indexReferenceInformation.getIndexName())
							.first()).get();
						return MapperC.of((fieldWithMetaString3 == null ? MapperS.<String>ofNull() : MapperS.of(fieldWithMetaString3.getValue())).map("to-string", Object::toString));
					}
					return MapperC.<String>ofNull();
				}).getMulti();
			
			return output;
		}
	}
}
