package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PartyIdentifierFormatEnum;
import drr.regulation.common.functions.IsOtherPayment;
import drr.standards.iosco.cde.reports.CDEOtherPaymentReceiverFormatRule;
import javax.inject.Inject;


@ImplementedBy(OtherPaymentReceiverFormatRule.OtherPaymentReceiverFormatRuleDefault.class)
public abstract class OtherPaymentReceiverFormatRule implements ReportFunction<TransferState, PartyIdentifierFormatEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEOtherPaymentReceiverFormatRule cDEOtherPaymentReceiverFormatRule;
	@Inject protected IsOtherPayment isOtherPayment;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PartyIdentifierFormatEnum evaluate(TransferState input) {
		PartyIdentifierFormatEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PartyIdentifierFormatEnum doEvaluate(TransferState input);

	public static class OtherPaymentReceiverFormatRuleDefault extends OtherPaymentReceiverFormatRule {
		@Override
		protected PartyIdentifierFormatEnum doEvaluate(TransferState input) {
			PartyIdentifierFormatEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PartyIdentifierFormatEnum assignOutput(PartyIdentifierFormatEnum output, TransferState input) {
			final MapperS<TransferState> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isOtherPayment.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(cDEOtherPaymentReceiverFormatRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
