package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.standards.iosco.cde.reports.CDEPriceScheduleAmountFormatPercentageRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(PriceInEffectBetweenTheUnadjustedEffectiveAndEndDatePercentageRule.PriceInEffectBetweenTheUnadjustedEffectiveAndEndDatePercentageRuleDefault.class)
public abstract class PriceInEffectBetweenTheUnadjustedEffectiveAndEndDatePercentageRule implements ReportFunction<PriceReportablePeriod, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPriceScheduleAmountFormatPercentageRule cDEPriceScheduleAmountFormatPercentageRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(PriceReportablePeriod input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(PriceReportablePeriod input);

	public static class PriceInEffectBetweenTheUnadjustedEffectiveAndEndDatePercentageRuleDefault extends PriceInEffectBetweenTheUnadjustedEffectiveAndEndDatePercentageRule {
		@Override
		protected BigDecimal doEvaluate(PriceReportablePeriod input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, PriceReportablePeriod input) {
			output = cDEPriceScheduleAmountFormatPercentageRule.evaluate(input);
			
			return output;
		}
	}
}
