package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.UnitType;
import cdm.base.math.functions.RoundToPrecision;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.product.asset.CommodityPayout;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg1;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsCommodityFixedPriceForward;
import drr.regulation.common.functions.IsCommodityFloatingPriceForward;
import drr.regulation.common.functions.IsCommoditySwapFixedFloat;
import drr.regulation.common.functions.IsCommoditySwapFloatFloat;
import drr.regulation.common.functions.IsEquity;
import drr.regulation.common.functions.IsEquityForward;
import drr.regulation.common.functions.IsProductETD;
import drr.regulation.common.functions.IsSingleCommodityPayoutProduct;
import drr.regulation.common.functions.TradableProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.standards.iosco.cde.reports.CDECommodityTotalNotionalQuantityRule;
import drr.standards.iosco.cde.reports.CDEEquityTotalNotionalQuantityRule;
import drr.standards.iosco.cde.reports.CDEFixedPriceTotalNotionalQuantityRule;
import drr.standards.iosco.cde.reports.CDEOptionTotalNotionalQuantityRule;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(TotalNotionalQuantityOfLeg1Rule.TotalNotionalQuantityOfLeg1RuleDefault.class)
public abstract class TotalNotionalQuantityOfLeg1Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDECommodityTotalNotionalQuantityRule cDECommodityTotalNotionalQuantityRule;
	@Inject protected CDEEquityTotalNotionalQuantityRule cDEEquityTotalNotionalQuantityRule;
	@Inject protected CDEFixedPriceTotalNotionalQuantityRule cDEFixedPriceTotalNotionalQuantityRule;
	@Inject protected CDEOptionTotalNotionalQuantityRule cDEOptionTotalNotionalQuantityRule;
	@Inject protected CommodityLeg1 commodityLeg1;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FixedPriceLeg1 fixedPriceLeg1;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
	@Inject protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
	@Inject protected IsCommoditySwapFixedFloat isCommoditySwapFixedFloat;
	@Inject protected IsCommoditySwapFloatFloat isCommoditySwapFloatFloat;
	@Inject protected IsEquity isEquity;
	@Inject protected IsEquityForward isEquityForward;
	@Inject protected IsProductETD isProductETD;
	@Inject protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
	@Inject protected Qualify_Commodity_Option qualify_Commodity_Option;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
	@Inject protected RoundToPrecision roundToPrecision;
	@Inject protected TradableProductForEvent tradableProductForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class TotalNotionalQuantityOfLeg1RuleDefault extends TotalNotionalQuantityOfLeg1Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<TradableProduct> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(tradableProductForEvent.evaluate(item.get())));
			final MapperS<BigDecimal> thenArg2 = thenArg1
				.mapSingleToItem(item -> {
					if (ComparisonResult.of(MapperS.of(isEquity.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get()))).or(ComparisonResult.of(MapperS.of(isEquityForward.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())))).getOrDefault(false)) {
						return MapperS.of(cDEEquityTotalNotionalQuantityRule.evaluate(item.get()));
					}
					final Boolean boolean0 = isCommoditySwapFloatFloat.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
					if ((boolean0 == null ? false : boolean0)) {
						return MapperS.of(cDECommodityTotalNotionalQuantityRule.evaluate(commodityLeg1.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())));
					}
					final Boolean boolean1 = isSingleCommodityPayoutProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
					if ((boolean1 == null ? false : boolean1)) {
						return MapperS.of(cDECommodityTotalNotionalQuantityRule.evaluate(MapperS.of(economicTermsForProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()));
					}
					final Boolean boolean2 = isCommodityFloatingPriceForward.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
					if ((boolean2 == null ? false : boolean2)) {
						return MapperS.of(cDECommodityTotalNotionalQuantityRule.evaluate(MapperS.of(economicTermsForProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()));
					}
					final Boolean boolean3 = isCommoditySwapFixedFloat.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
					if ((boolean3 == null ? false : boolean3)) {
						return MapperS.of(cDEFixedPriceTotalNotionalQuantityRule.evaluate(fixedPriceLeg1.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())));
					}
					final Boolean boolean4 = isCommodityFixedPriceForward.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
					if ((boolean4 == null ? false : boolean4)) {
						return MapperS.of(cDEFixedPriceTotalNotionalQuantityRule.evaluate(MapperS.of(economicTermsForProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get()));
					}
					final Boolean boolean5 = isSingleCommodityPayoutProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
					if ((boolean5 == null ? false : boolean5)) {
						return MapperS.of(cDECommodityTotalNotionalQuantityRule.evaluate(MapperS.of(economicTermsForProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()));
					}
					final Boolean boolean6 = isCommodityFloatingPriceForward.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
					if ((boolean6 == null ? false : boolean6)) {
						return MapperS.of(cDECommodityTotalNotionalQuantityRule.evaluate(MapperS.of(economicTermsForProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()));
					}
					final Boolean boolean7 = isCommodityFixedPriceForward.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
					if ((boolean7 == null ? false : boolean7)) {
						return MapperS.of(cDEFixedPriceTotalNotionalQuantityRule.evaluate(MapperS.of(economicTermsForProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get()));
					}
					if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swaption.evaluate(economicTermsForProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())))).and(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTermsForProduct.evaluate(underlierForProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())))))).getOrDefault(false)) {
						return MapperS.of(cDECommodityTotalNotionalQuantityRule.evaluate(commodityLeg1.evaluate(underlierForProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get()))));
					}
					if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swaption.evaluate(economicTermsForProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())))).and(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTermsForProduct.evaluate(underlierForProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())))))).getOrDefault(false)) {
						return MapperS.of(cDEFixedPriceTotalNotionalQuantityRule.evaluate(fixedPriceLeg1.evaluate(underlierForProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get()))));
					}
					final Boolean boolean8 = qualify_Commodity_Option.evaluate(economicTermsForProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get()));
					if ((boolean8 == null ? false : boolean8)) {
						return MapperS.of(cDEOptionTotalNotionalQuantityRule.evaluate(MapperS.of(economicTermsForProduct.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()));
					}
					final Boolean boolean9 = isProductETD.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
					if ((boolean9 == null ? false : boolean9)) {
						final MapperC<FieldWithMetaNonNegativeQuantitySchedule> _thenArg0 = MapperS.of(item.<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity())
							.filterItemNullSafe(_item -> exists(_item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).get());
						final MapperC<BigDecimal> _thenArg1 = _thenArg0
							.mapItem(_item -> _item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
						return MapperS.of(_thenArg1.get());
					}
					return MapperS.<BigDecimal>ofNull();
				});
			final MapperS<BigDecimal> thenArg3 = thenArg2
				.mapSingleToItem(item -> MapperS.of(roundToPrecision.evaluate(item.get(), 5, RoundingDirectionEnum.NEAREST)));
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg3.get())).get();
			
			return output;
		}
	}
}
