package drr.regulation.fca.ukemir.refit.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.PriceAndNotation;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class PriceAndNotationTypeFormatValidator implements Validator<PriceAndNotation> {

	private List<ComparisonResult> getComparisonResults(PriceAndNotation o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("priceMonetary", o.getPriceMonetary(), of(18), of(13), empty(), empty()), 
				checkNumber("pricePercentage", o.getPricePercentage(), of(11), of(10), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceAndNotation o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("PriceAndNotation", ValidationResult.ValidationType.TYPE_FORMAT, "PriceAndNotation", path, "", res.getError());
				}
				return success("PriceAndNotation", ValidationResult.ValidationType.TYPE_FORMAT, "PriceAndNotation", path, "");
			})
			.collect(toList());
	}

}
