package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.53.0
 */
@RosettaDataRule("FCAUKEMIRTransactionReportUKEMIR_VR_1012_01")
@ImplementedBy(FCAUKEMIRTransactionReportUKEMIR_VR_1012_01.Default.class)
public interface FCAUKEMIRTransactionReportUKEMIR_VR_1012_01 extends Validator<FCAUKEMIRTransactionReport> {
	
	String NAME = "FCAUKEMIRTransactionReportUKEMIR_VR_1012_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then (if natureOfCounterparty2 = \"F\" and corporateSectorOfTheCounterparty2 exists then corporateSectorOfTheCounterparty2 extract ([\"INVF\", \"CDTI\", \"INUN\", \"UCIT\", \"ORPI\", \"AIFD\", \"CSDS\"] any = item) then all = True)";
	
	class Default implements FCAUKEMIRTransactionReportUKEMIR_VR_1012_01 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getActionType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					final MapperC<Boolean> thenArg;
					if (areEqual(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getNatureOfCounterparty2", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getNatureOfCounterparty2()), MapperS.of("F"), CardinalityOperator.All).and(exists(MapperS.of(fCAUKEMIRTransactionReport).<String>mapC("getCorporateSectorOfTheCounterparty2", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getCorporateSectorOfTheCounterparty2()))).getOrDefault(false)) {
						thenArg = MapperS.of(fCAUKEMIRTransactionReport).<String>mapC("getCorporateSectorOfTheCounterparty2", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getCorporateSectorOfTheCounterparty2())
							.mapItem(item -> areEqual(MapperC.<String>of(MapperS.of("INVF"), MapperS.of("CDTI"), MapperS.of("INUN"), MapperS.of("UCIT"), MapperS.of("ORPI"), MapperS.of("AIFD"), MapperS.of("CSDS")), item, CardinalityOperator.Any).asMapper());
					} else {
						thenArg = MapperC.<Boolean>ofNull();
					}
					return ComparisonResult.of(areEqual(thenArg, MapperS.of(true), CardinalityOperator.All).asMapper());
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRTransactionReportUKEMIR_VR_1012_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
