package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.EventTypeEnum;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.53.0
 */
@RosettaDataRule("FCAUKEMIRTransactionReportUKEMIR_VR_2003_03")
@ImplementedBy(FCAUKEMIRTransactionReportUKEMIR_VR_2003_03.Default.class)
public interface FCAUKEMIRTransactionReportUKEMIR_VR_2003_03 extends Validator<FCAUKEMIRTransactionReport> {
	
	String NAME = "FCAUKEMIRTransactionReportUKEMIR_VR_2003_03";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if actionType = ActionTypeEnum -> NEWT to-string and [ EventTypeEnum -> NOVA to-string, EventTypeEnum -> EXER to-string, EventTypeEnum -> ALOC to-string, EventTypeEnum -> CLRG to-string, EventTypeEnum -> CORP to-string ] all <> eventType then priorUTI is absent and priorUTIProprietary is absent";
	
	class Default implements FCAUKEMIRTransactionReportUKEMIR_VR_2003_03 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getActionType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (areEqual(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getActionType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).and(notEqual(MapperC.<String>of(MapperS.of(EventTypeEnum.NOVA).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.EXER).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ALOC).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLRG).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CORP).map("to-string", EventTypeEnum::toDisplayString)), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getEventType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getEventType()), CardinalityOperator.All)).getOrDefault(false)) {
						return notExists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getPriorUTI", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getPriorUTI())).and(notExists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getPriorUTIProprietary", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getPriorUTIProprietary())));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRTransactionReportUKEMIR_VR_2003_03 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
