package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.event.common.Trade;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_AssetClass_ForeignExchange;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import javax.inject.Inject;


@ImplementedBy(AssetClassRule.AssetClassRuleDefault.class)
public abstract class AssetClassRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForJFSA isAllowableActionForJFSA;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
	@Inject protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
	@Inject protected Qualify_AssetClass_ForeignExchange qualify_AssetClass_ForeignExchange;
	@Inject protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class AssetClassRuleDefault extends AssetClassRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForJFSA.evaluate(item.get()));
			final MapperS<Trade> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperS<EconomicTerms> thenArg2 = thenArg1
				.mapSingleToItem(item -> MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()));
			output = thenArg2
				.mapSingleToItem(item -> {
					final Boolean boolean0 = qualify_AssetClass_InterestRate.evaluate(item.get());
					if ((boolean0 == null ? false : boolean0)) {
						return MapperS.of("INTR");
					}
					final Boolean boolean1 = qualify_AssetClass_Credit.evaluate(item.get());
					if ((boolean1 == null ? false : boolean1)) {
						return MapperS.of("CRDT");
					}
					final Boolean boolean2 = qualify_AssetClass_Equity.evaluate(item.get());
					if ((boolean2 == null ? false : boolean2)) {
						return MapperS.of("EQUI");
					}
					final Boolean boolean3 = qualify_AssetClass_ForeignExchange.evaluate(item.get());
					if ((boolean3 == null ? false : boolean3)) {
						return MapperS.of("CURR");
					}
					return MapperS.of("OTHR");
				}).get();
			
			return output;
		}
	}
}
