package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.base.math.DatedValue;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetLeg2ResolvablePriceQuantity;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.jfsa.rewrite.trade.NotionalAmountScheduleLeg2Report;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(NotionalAmountScheduleLeg2Rule.NotionalAmountScheduleLeg2RuleDefault.class)
public abstract class NotionalAmountScheduleLeg2Rule implements ReportFunction<TransactionReportInstruction, List<? extends NotionalAmountScheduleLeg2Report>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected GetLeg2ResolvablePriceQuantity getLeg2ResolvablePriceQuantity;
	@Inject protected IsAllowableActionForJFSA isAllowableActionForJFSA;
	@Inject protected NotionalAmountScheduleLeg2AmountRule notionalAmountScheduleLeg2AmountRule;
	@Inject protected NotionalAmountScheduleLeg2EffectiveDateRule notionalAmountScheduleLeg2EffectiveDateRule;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends NotionalAmountScheduleLeg2Report> evaluate(TransactionReportInstruction input) {
		List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends NotionalAmountScheduleLeg2Report> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(NotionalAmountScheduleLeg2Report::build).collect(Collectors.toList());
			objectValidator.validate(NotionalAmountScheduleLeg2Report.class, output);
		}
		
		return output;
	}

	protected abstract List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> doEvaluate(TransactionReportInstruction input);

	public static class NotionalAmountScheduleLeg2RuleDefault extends NotionalAmountScheduleLeg2Rule {
		@Override
		protected List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> doEvaluate(TransactionReportInstruction input) {
			List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> assignOutput(List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForJFSA.evaluate(item.get()));
			final MapperS<Trade> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperC<DatedValue> thenArg2 = thenArg1
				.mapSingleToList(item -> MapperS.of(getLeg2ResolvablePriceQuantity.evaluate(item.get())).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()));
			final MapperC<QuantityReportablePeriod> thenArg3 = thenArg2
				.mapItem(notionalAmountPeriod -> MapperS.of(QuantityReportablePeriod.builder()
					.setPeriodValue(notionalAmountPeriod.<BigDecimal>map("getValue", datedValue -> datedValue.getValue()).get())
					.setPeriodEffectiveDate(notionalAmountPeriod.<Date>map("getDate", datedValue -> datedValue.getDate()).get())
					.setPeriodEndDate(null)
					.build()));
			final MapperC<NotionalAmountScheduleLeg2Report> thenArg4 = thenArg3
				.mapItem(item -> MapperS.of(NotionalAmountScheduleLeg2Report.builder()
					.setAmount(notionalAmountScheduleLeg2AmountRule.evaluate(item.get()))
					.setEffectiveDate(notionalAmountScheduleLeg2EffectiveDateRule.evaluate(item.get()))
					.build()));
			output = toBuilder(thenArg4
				.sort(item -> item.<Date>map("getEffectiveDate", notionalAmountScheduleLeg2Report -> notionalAmountScheduleLeg2Report.getEffectiveDate())).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
